/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import javax.servlet.SessionCookieConfig;
import org.apache.catalina.Context;

public class SessionConfig {
    private static final String DEFAULT_SESSION_COOKIE_NAME = "JSESSIONID";
    private static final String DEFAULT_SESSION_PARAMETER_NAME = "jsessionid";

    public static String getSessionCookieName(Context context) {
        return SessionConfig.getConfiguredSessionCookieName(context, DEFAULT_SESSION_COOKIE_NAME);
    }

    public static String getSessionUriParamName(Context context) {
        return SessionConfig.getConfiguredSessionCookieName(context, DEFAULT_SESSION_PARAMETER_NAME);
    }

    private static String getConfiguredSessionCookieName(Context context, String string) {
        if (context != null) {
            String string2 = context.getSessionCookieName();
            if (string2 != null && !string2.isEmpty()) {
                return string2;
            }
            SessionCookieConfig sessionCookieConfig = context.getServletContext().getSessionCookieConfig();
            string2 = sessionCookieConfig.getName();
            if (string2 != null && !string2.isEmpty()) {
                return string2;
            }
        }
        return string;
    }

    public static String getSessionCookiePath(Context context) {
        SessionCookieConfig sessionCookieConfig = context.getServletContext().getSessionCookieConfig();
        String string = context.getSessionCookiePath();
        if (string == null || string.isEmpty()) {
            string = sessionCookieConfig.getPath();
        }
        if (string == null || string.isEmpty()) {
            string = context.getEncodedPath();
        }
        if (context.getSessionCookiePathUsesTrailingSlash()) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
        } else if (string.isEmpty()) {
            string = "/";
        }
        return string;
    }

    private SessionConfig() {
    }
}

