/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.tesselatable;

import org.sunflow.SunflowAPI;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Tesselatable;
import org.sunflow.core.primitive.QuadMesh;
import org.sunflow.core.primitive.TriangleMesh;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;

public class BezierMesh
implements Tesselatable {
    private int subdivs = 8;
    private boolean smooth = true;
    private boolean quads = false;
    private float[][] patches;

    public BezierMesh() {
        this(null);
    }

    public BezierMesh(float[][] fArray) {
        this.patches = fArray;
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        BoundingBox boundingBox = new BoundingBox();
        if (matrix4 == null) {
            for (int i = 0; i < this.patches.length; ++i) {
                float[] fArray = this.patches[i];
                for (int j = 0; j < fArray.length; j += 3) {
                    boundingBox.include(fArray[j], fArray[j + 1], fArray[j + 2]);
                }
            }
        } else {
            for (int i = 0; i < this.patches.length; ++i) {
                float[] fArray = this.patches[i];
                for (int j = 0; j < fArray.length; j += 3) {
                    float f = fArray[j];
                    float f2 = fArray[j + 1];
                    float f3 = fArray[j + 2];
                    float f4 = matrix4.transformPX(f, f2, f3);
                    float f5 = matrix4.transformPY(f, f2, f3);
                    float f6 = matrix4.transformPZ(f, f2, f3);
                    boundingBox.include(f4, f5, f6);
                }
            }
        }
        return boundingBox;
    }

    private float[] bernstein(float f) {
        float[] fArray = new float[4];
        float f2 = 1.0f - f;
        fArray[0] = f2 * f2 * f2;
        fArray[1] = 3.0f * f * f2 * f2;
        fArray[2] = 3.0f * f * f * f2;
        fArray[3] = f * f * f;
        return fArray;
    }

    private float[] bernsteinDeriv(float f) {
        if (!this.smooth) {
            return null;
        }
        float[] fArray = new float[4];
        float f2 = 1.0f - f;
        fArray[0] = 3.0f * (0.0f - f2 * f2);
        fArray[1] = 3.0f * (f2 * f2 - 2.0f * f * f2);
        fArray[2] = 3.0f * (2.0f * f * f2 - f * f);
        fArray[3] = 3.0f * (f * f - 0.0f);
        return fArray;
    }

    private void getPatchPoint(float f, float f2, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, Point3 point3, Vector3 vector3) {
        float f3;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = 0;
            while (n2 < 4) {
                f3 = fArray2[n2] * fArray3[i];
                f4 += fArray[n + 0] * f3;
                f5 += fArray[n + 1] * f3;
                f6 += fArray[n + 2] * f3;
                ++n2;
                n += 3;
            }
        }
        point3.x = f4;
        point3.y = f5;
        point3.z = f6;
        if (vector3 != null) {
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            f3 = 0.0f;
            float f10 = 0.0f;
            float f11 = 0.0f;
            int n3 = 0;
            for (int i = 0; i < 4; ++i) {
                int n4 = 0;
                while (n4 < 4) {
                    float f12 = fArray4[n4] * fArray3[i];
                    f7 += fArray[n3 + 0] * f12;
                    f8 += fArray[n3 + 1] * f12;
                    f9 += fArray[n3 + 2] * f12;
                    float f13 = fArray2[n4] * fArray5[i];
                    f3 += fArray[n3 + 0] * f13;
                    f10 += fArray[n3 + 1] * f13;
                    f11 += fArray[n3 + 2] * f13;
                    ++n4;
                    n3 += 3;
                }
            }
            vector3.x = f8 * f11 - f9 * f10;
            vector3.y = f9 * f3 - f7 * f11;
            vector3.z = f7 * f10 - f8 * f3;
        }
    }

    public PrimitiveList tesselate() {
        float[] fArray = new float[this.patches.length * (this.subdivs + 1) * (this.subdivs + 1) * 3];
        float[] fArray2 = this.smooth ? new float[this.patches.length * (this.subdivs + 1) * (this.subdivs + 1) * 3] : null;
        float[] fArray3 = new float[this.patches.length * (this.subdivs + 1) * (this.subdivs + 1) * 2];
        int[] nArray = new int[this.patches.length * this.subdivs * this.subdivs * (this.quads ? 4 : 6)];
        int n = 0;
        int n2 = 0;
        float f = 1.0f / (float)this.subdivs;
        int n3 = this.subdivs + 1;
        Point3 point3 = new Point3();
        Vector3 vector3 = this.smooth ? new Vector3() : null;
        for (float[] fArray4 : this.patches) {
            int n4;
            int n5;
            int n6 = 0;
            for (n5 = 0; n5 <= this.subdivs; ++n5) {
                float f2 = (float)n5 * f;
                float[] fArray5 = this.bernstein(f2);
                float[] fArray6 = this.bernsteinDeriv(f2);
                n4 = 0;
                while (n4 <= this.subdivs) {
                    float f3 = (float)n4 * f;
                    float[] fArray7 = this.bernstein(f3);
                    float[] fArray8 = this.bernsteinDeriv(f3);
                    this.getPatchPoint(f2, f3, fArray4, fArray5, fArray7, fArray6, fArray8, point3, vector3);
                    fArray[n + n6 + 0] = point3.x;
                    fArray[n + n6 + 1] = point3.y;
                    fArray[n + n6 + 2] = point3.z;
                    if (this.smooth) {
                        fArray2[n + n6 + 0] = vector3.x;
                        fArray2[n + n6 + 1] = vector3.y;
                        fArray2[n + n6 + 2] = vector3.z;
                    }
                    fArray3[(n + n6) / 3 * 2 + 0] = f2;
                    fArray3[(n + n6) / 3 * 2 + 1] = f3;
                    ++n4;
                    n6 += 3;
                }
            }
            n6 = n / 3;
            for (n5 = 0; n5 < this.subdivs; ++n5) {
                for (int i = 0; i < this.subdivs; ++i) {
                    int n7 = (n5 + 0) * n3 + (i + 0);
                    int n8 = (n5 + 1) * n3 + (i + 0);
                    n4 = (n5 + 0) * n3 + (i + 1);
                    int n9 = (n5 + 1) * n3 + (i + 1);
                    if (this.quads) {
                        nArray[n2 + 0] = n6 + n4;
                        nArray[n2 + 1] = n6 + n7;
                        nArray[n2 + 2] = n6 + n8;
                        nArray[n2 + 3] = n6 + n9;
                        n2 += 4;
                        continue;
                    }
                    nArray[n2 + 0] = n6 + n7;
                    nArray[n2 + 1] = n6 + n8;
                    nArray[n2 + 2] = n6 + n4;
                    nArray[n2 + 3] = n6 + n8;
                    nArray[n2 + 4] = n6 + n9;
                    nArray[n2 + 5] = n6 + n4;
                    n2 += 6;
                }
            }
            n += n3 * n3 * 3;
        }
        Object object = new ParameterList();
        ((ParameterList)object).addPoints("points", ParameterList.InterpolationType.VERTEX, fArray);
        if (this.quads) {
            ((ParameterList)object).addIntegerArray("quads", nArray);
        } else {
            ((ParameterList)object).addIntegerArray("triangles", nArray);
        }
        ((ParameterList)object).addTexCoords("uvs", ParameterList.InterpolationType.VERTEX, fArray3);
        if (this.smooth) {
            ((ParameterList)object).addVectors("normals", ParameterList.InterpolationType.VERTEX, fArray2);
        }
        PrimitiveList primitiveList = this.quads ? new QuadMesh() : new TriangleMesh();
        primitiveList.update((ParameterList)object, null);
        ((ParameterList)object).clear(true);
        return primitiveList;
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.subdivs = parameterList.getInt("subdivs", this.subdivs);
        this.smooth = parameterList.getBoolean("smooth", this.smooth);
        this.quads = parameterList.getBoolean("quads", this.quads);
        int n = parameterList.getInt("nu", 0);
        int n2 = parameterList.getInt("nv", 0);
        parameterList.setVertexCount(n * n2);
        boolean bl = parameterList.getBoolean("uwrap", false);
        boolean bl2 = parameterList.getBoolean("vwrap", false);
        ParameterList.FloatParameter floatParameter = parameterList.getPointArray("points");
        if (floatParameter != null && floatParameter.interp == ParameterList.InterpolationType.VERTEX) {
            int n3;
            int n4 = bl ? n / 3 : (n - 4) / 3 + 1;
            int n5 = n3 = bl2 ? n2 / 3 : (n2 - 4) / 3 + 1;
            if (n4 < 1 || n3 < 1) {
                UI.printError(UI.Module.GEOM, "Invalid number of patches for bezier mesh - ignoring", new Object[0]);
                return false;
            }
            this.patches = new float[n4 * n3][];
            int n6 = 0;
            for (int i = 0; i < n3; ++i) {
                int n7 = 0;
                while (n7 < n4) {
                    this.patches[n6] = new float[48];
                    float[] fArray = this.patches[n6];
                    int n8 = n7 * 3;
                    int n9 = i * 3;
                    for (int j = 0; j < 4; ++j) {
                        for (int k = 0; k < 4; ++k) {
                            int n10 = (n8 + k) % n;
                            int n11 = (n9 + j) % n2;
                            fArray[3 * (j * 4 + k) + 0] = floatParameter.data[3 * (n10 + n * n11) + 0];
                            fArray[3 * (j * 4 + k) + 1] = floatParameter.data[3 * (n10 + n * n11) + 1];
                            fArray[3 * (j * 4 + k) + 2] = floatParameter.data[3 * (n10 + n * n11) + 2];
                        }
                    }
                    ++n7;
                    ++n6;
                }
            }
        }
        if (this.subdivs < 1) {
            UI.printError(UI.Module.GEOM, "Invalid subdivisions for bezier mesh - ignoring", new Object[0]);
            return false;
        }
        if (this.patches == null) {
            UI.printError(UI.Module.GEOM, "No patch data present in bezier mesh - ignoring", new Object[0]);
            return false;
        }
        return true;
    }
}

