/*
 * Decompiled with CFR 0.152.
 */
package hughai.unitdata;

import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.PlayerObjects;
import hughai.unitdata.BuildTable;
import hughai.unitdata.UnitController;
import hughai.utils.LogFile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;

public class BuildTree {
    private HashSet<UnitDef> thisTeamsUnitDefs = new HashSet();
    private HashMap<String, UnitDef> thisTeamsUnitDefsByName = new HashMap();
    boolean[][] directedGraphUnitDefIdToUnitDefId;
    boolean[] seenthisunitdefidbefore;
    PlayerObjects playerObjects;
    CSAI csai;
    OOAICallback aicallback;
    LogFile logfile;
    BuildTable buildTable;

    public BuildTree(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.buildTable = playerObjects.getBuildTable();
        this.logfile = playerObjects.getLogFile();
        this.init();
        this.playerObjects.getUnitController().registerListener(new UnitListener());
    }

    void init() {
        this.playerObjects.getLogFile().WriteLine("building buildtree directed graph...");
        UnitDef[] unitDefArray = this.playerObjects.getBuildTable().availableunittypes;
        this.directedGraphUnitDefIdToUnitDefId = new boolean[this.buildTable.getLargestUnitDefId() + 1][this.buildTable.getLargestUnitDefId() + 1];
        this.seenthisunitdefidbefore = new boolean[this.buildTable.getLargestUnitDefId() + 1];
        for (UnitDef unitDef : unitDefArray) {
            int n = unitDef.getUnitDefId();
            for (UnitDef unitDef2 : unitDef.getBuildOptions()) {
                int n2 = unitDef2.getUnitDefId();
                this.directedGraphUnitDefIdToUnitDefId[n][n2] = true;
            }
        }
        this.playerObjects.getLogFile().WriteLine(" ... done");
    }

    void debug(Object object) {
        this.playerObjects.getLogFile().WriteLine("BuildTree: " + object);
    }

    public boolean isOurTeam(UnitDef unitDef) {
        return this.thisTeamsUnitDefs.contains(unitDef);
    }

    public boolean isOurTeam(String string) {
        return this.thisTeamsUnitDefsByName.containsKey(string);
    }

    public String listToOurTeamsUnitName(List<String> list) {
        for (String string : list) {
            if (!this.thisTeamsUnitDefsByName.containsKey(string)) continue;
            return string;
        }
        return null;
    }

    public boolean CanBuild(String string, String string2) {
        UnitDef unitDef = this.buildTable.getUnitDefByName(string);
        UnitDef unitDef2 = this.buildTable.getUnitDefByName(string2);
        if (unitDef == null) {
            return false;
        }
        if (unitDef2 == null) {
            this.playerObjects.getLogFile().WriteLine("WARNING: no such unit name as " + string2 + " please check your configuration.");
            return false;
        }
        int n = unitDef.getUnitDefId();
        int n2 = unitDef2.getUnitDefId();
        return this.directedGraphUnitDefIdToUnitDefId[n][n2];
    }

    class UnitListener
    extends UnitController.UnitAdapter {
        UnitListener() {
        }

        @Override
        public void UnitAdded(Unit unit) {
            BuildTree.this.debug("unitadded");
            UnitDef unitDef = BuildTree.this.playerObjects.getUnitController().getUnitDef(unit);
            if (unitDef == null) {
                BuildTree.this.debug("... unitdef null");
                return;
            }
            BuildTree.this.debug(" ... " + unit.getDef().getUnitDefId() + " " + unit.getDef().getHumanName());
            if (BuildTree.this.thisTeamsUnitDefs.contains(unitDef)) {
                BuildTree.this.debug(" ...  seen before ... ");
                return;
            }
            BuildTree.this.debug(" ... not seen before ... ");
            int n = unitDef.getUnitDefId();
            Stack<Integer> stack = new Stack<Integer>();
            stack.push(n);
            while (!stack.isEmpty()) {
                int n2 = (Integer)stack.pop();
                if (BuildTree.this.seenthisunitdefidbefore[n2]) continue;
                BuildTree.this.seenthisunitdefidbefore[n2] = true;
                UnitDef unitDef2 = BuildTree.this.buildTable.getUnitDefByUnitDefId(n2);
                BuildTree.this.thisTeamsUnitDefs.add(unitDef2);
                BuildTree.this.thisTeamsUnitDefsByName.put(unitDef2.getName(), unitDef2);
                for (int i = 0; i <= BuildTree.this.buildTable.getLargestUnitDefId(); ++i) {
                    if (!BuildTree.this.directedGraphUnitDefIdToUnitDefId[n2][i]) continue;
                    stack.push(i);
                }
            }
        }
    }
}

