/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.axiom;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.model.axiom.SubjectDefinitionExtractor;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;

public class DefaultSubjectDefinitionExtractor
implements SubjectDefinitionExtractor {
    @Override
    public Set<OWLAxiom> getDefiningAxioms(OWLObject subject, final OWLOntology ontology) {
        return new HashSet<OWLAxiom>((Collection)subject.accept((OWLObjectVisitorEx)new OWLObjectVisitorExAdapter<Set<? extends OWLAxiom>>(this, Collections.emptySet()){
            final /* synthetic */ DefaultSubjectDefinitionExtractor this$0;
            {
                this.this$0 = this$0;
                super((Object)defaultReturnValue);
            }

            public Set<? extends OWLAxiom> visit(OWLClass cls) {
                return ontology.getAxioms(cls, Imports.EXCLUDED);
            }

            public Set<? extends OWLAxiom> visit(OWLObjectProperty property) {
                return ontology.getAxioms((OWLObjectPropertyExpression)property, Imports.EXCLUDED);
            }

            public Set<? extends OWLAxiom> visit(OWLDataProperty property) {
                return ontology.getAxioms(property, Imports.EXCLUDED);
            }

            public Set<? extends OWLAxiom> visit(OWLNamedIndividual individual) {
                return ontology.getAxioms((OWLIndividual)individual, Imports.EXCLUDED);
            }

            public Set<? extends OWLAxiom> visit(OWLDatatype datatype) {
                return ontology.getAxioms(datatype, Imports.EXCLUDED);
            }

            public Set<? extends OWLAxiom> visit(OWLAnnotationProperty property) {
                return ontology.getAxioms(property, Imports.EXCLUDED);
            }

            public Set<? extends OWLAxiom> visit(IRI iri) {
                HashSet axioms = Sets.newHashSet();
                axioms.addAll(ontology.getAnnotationAssertionAxioms((OWLAnnotationSubject)iri));
                for (OWLEntity entity : ontology.getEntitiesInSignature(iri, Imports.INCLUDED)) {
                    axioms.addAll(this.this$0.getDefiningAxioms((OWLObject)entity, ontology));
                }
                return axioms;
            }
        }));
    }
}

