/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dot;

import java.io.File;

public enum ExeState {
    NULL_UNDEFINED,
    OK,
    DOES_NOT_EXIST,
    IS_A_DIRECTORY,
    NOT_A_FILE,
    CANNOT_BE_READ;


    public static ExeState checkFile(File dotExe) {
        if (dotExe == null) {
            return NULL_UNDEFINED;
        }
        if (!dotExe.exists()) {
            return DOES_NOT_EXIST;
        }
        if (dotExe.isDirectory()) {
            return IS_A_DIRECTORY;
        }
        if (!dotExe.isFile()) {
            return NOT_A_FILE;
        }
        if (!dotExe.canRead()) {
            return CANNOT_BE_READ;
        }
        return OK;
    }

    public String getTextMessage() {
        switch (this.ordinal()) {
            case 1: {
                return "Dot executable OK";
            }
            case 0: {
                return "No dot executable found";
            }
            case 2: {
                return "Dot executable does not exist";
            }
            case 3: {
                return "Dot executable should be an executable, not a directory";
            }
            case 4: {
                return "Dot executable is not a valid file";
            }
            case 5: {
                return "Dot executable cannot be read";
            }
        }
        throw new IllegalStateException();
    }

    public String getTextMessage(File exe) {
        switch (this.ordinal()) {
            case 1: {
                return "File " + exe.getAbsolutePath() + " OK";
            }
            case 0: {
                return NULL_UNDEFINED.getTextMessage();
            }
            case 2: {
                return "File " + exe.getAbsolutePath() + " does not exist";
            }
            case 3: {
                return "File " + exe.getAbsolutePath() + " should be an executable, not a directory";
            }
            case 4: {
                return "File " + exe.getAbsolutePath() + " is not a valid file";
            }
            case 5: {
                return "File " + exe.getAbsolutePath() + " cannot be read";
            }
        }
        throw new IllegalStateException();
    }
}

