<?php

namespace Gender {

	/**
	 * @link https://php.net/manual/en/class.gender.php
	 * @since PECL gender >= 0.6.0
	 */
	class Gender {

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int IS_FEMALE = 70;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int IS_MOSTLY_FEMALE = 102;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int IS_MALE = 77;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int IS_MOSTLY_MALE = 109;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int IS_UNISEX_NAME = 63;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int IS_A_COUPLE = 67;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int NAME_NOT_FOUND = 32;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int ERROR_IN_NAME = 69;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int ANY_COUNTRY = 0;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int BRITAIN = 1;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int IRELAND = 2;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int USA = 3;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int SPAIN = 4;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int PORTUGAL = 5;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int ITALY = 6;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int MALTA = 7;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int FRANCE = 8;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int BELGIUM = 9;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int LUXEMBOURG = 10;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int NETHERLANDS = 11;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int GERMANY = 12;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int EAST_FRISIA = 13;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int AUSTRIA = 14;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int SWISS = 15;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int ICELAND = 16;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int DENMARK = 17;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int NORWAY = 18;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int SWEDEN = 19;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int FINLAND = 20;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int ESTONIA = 21;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int LATVIA = 22;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int LITHUANIA = 23;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int POLAND = 24;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int CZECH_REP = 25;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int SLOVAKIA = 26;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int HUNGARY = 27;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int ROMANIA = 28;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int BULGARIA = 29;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int BOSNIA = 30;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int CROATIA = 31;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int KOSOVO = 32;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int MACEDONIA = 33;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int MONTENEGRO = 34;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int SERBIA = 35;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int SLOVENIA = 36;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int ALBANIA = 37;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int GREECE = 38;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int RUSSIA = 39;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int BELARUS = 40;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int MOLDOVA = 41;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int UKRAINE = 42;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int ARMENIA = 43;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int AZERBAIJAN = 44;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int GEORGIA = 45;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int KAZAKH_UZBEK = 46;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int TURKEY = 47;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int ARABIA = 48;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int ISRAEL = 49;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int CHINA = 50;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int INDIA = 51;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int JAPAN = 52;

		/**
		 * @var int
		 * @link https://php.net/manual/en/class.gender.php
		 */
		const int KOREA = 53;

		/**
		 * Construct the Gender object
		 * <p>Create a Gender object optionally connecting to an external name dictionary. When no external database was given, compiled in data will be used.</p>
		 * @param string $dsn <p>DSN to open.</p>
		 * @return self
		 * @link https://php.net/manual/en/gender-gender.construct.php
		 * @since PECL gender >= 0.6.0
		 */
		public function __construct(string $dsn = null) {}

		/**
		 * Connect to an external name dictionary
		 * <p>Connect to an external name dictionary. Currently only streams are supported.</p>
		 * @param string $dsn <p>DSN to open.</p>
		 * @return bool <p>Boolean as success of failure.</p>
		 * @link https://php.net/manual/en/gender-gender.connect.php
		 * @since PECL gender >= 0.6.0
		 */
		public function connect(string $dsn): bool {}

		/**
		 * Get textual country representation
		 * <p>Returns the textual representation of a country from a Gender class constant.</p>
		 * @param int $country <p>A country ID specified by a <code>Gender\Gender</code> class constant.</p>
		 * @return array|false <p>Returns an array with the short and full names of the country on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/gender-gender.country.php
		 * @since PECL gender >= 0.8.0
		 */
		public function country(int $country): array|false {}

		/**
		 * Get gender of a name
		 * <p>Get the gender of the name in a particular country.</p>
		 * @param string $name <p>Name to check.</p>
		 * @param int $country <p>Country id identified by Gender class constant.</p>
		 * @return int <p>Returns gender of the name.</p>
		 * @link https://php.net/manual/en/gender-gender.get.php
		 * @since PECL gender >= 0.6.0
		 */
		public function get(string $name, int $country = null): int {}

		/**
		 * Check if the name0 is an alias of the name1
		 * <p>Check whether the name0 is a nick of the name1.</p>
		 * @param string $name0 <p>Name to check.</p>
		 * @param string $name1 <p>Name to check.</p>
		 * @param int $country <p>Country id identified by Gender class constant. If ommited ANY_COUNTRY is used.</p>
		 * @return array <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/gender-gender.isnick.php
		 * @since PECL gender >= 0.9.0
		 */
		public function isNick(string $name0, string $name1, int $country = null): array {}

		/**
		 * Get similar names
		 * <p>Get similar names for the given name and country.</p>
		 * @param string $name <p>Name to check.</p>
		 * @param int $country <p>Country id identified by Gender class constant. If ommited ANY_COUNTRY is used.</p>
		 * @return array <p>Returns an array with the similar names found.</p>
		 * @link https://php.net/manual/en/gender-gender.similarnames.php
		 * @since PECL gender >= 0.9.0
		 */
		public function similarNames(string $name, int $country = null): array {}
	}

}
