/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.php.phpunit.Bundle;
import org.openide.util.Parameters;

public enum PhpUnitVersion {
    PHP_UNIT_9(Bundle.PhpUnitVersion_PHP_UNIT_9()),
    PHP_UNIT_10(Bundle.PhpUnitVersion_PHP_UNIT_10());

    private static final Logger LOGGER;
    private final String displayName;

    private PhpUnitVersion(String displayName) {
        this.displayName = displayName;
    }

    public static PhpUnitVersion getDefault() {
        PhpUnitVersion[] phpUnitVersions = PhpUnitVersion.values();
        return phpUnitVersions[0];
    }

    public static PhpUnitVersion fromString(@NonNull String version) {
        Parameters.notNull((CharSequence)"version", (Object)version);
        String[] versions = version.split("\\.");
        try {
            int majorVersion = Integer.parseInt(versions[0]);
            if (majorVersion >= 10) {
                return PHP_UNIT_10;
            }
            if (majorVersion <= 9) {
                return PHP_UNIT_9;
            }
            LOGGER.log(Level.WARNING, "Unexpected PHPUnit major version:{0} ({1})", new Object[]{majorVersion, version});
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return PhpUnitVersion.getDefault();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean useNetBeansSuite() {
        return this == PHP_UNIT_9;
    }

    public String toString() {
        return this.getDisplayName();
    }

    static {
        LOGGER = Logger.getLogger(PhpUnitVersion.class.getName());
    }
}

