/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousDatabaseBackupConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="manualBackupBucketName")
    private final String manualBackupBucketName;
    @JsonProperty(value="manualBackupType")
    private final ManualBackupType manualBackupType;

    @Deprecated
    @ConstructorProperties(value={"manualBackupBucketName", "manualBackupType"})
    public AutonomousDatabaseBackupConfig(String manualBackupBucketName, ManualBackupType manualBackupType) {
        this.manualBackupBucketName = manualBackupBucketName;
        this.manualBackupType = manualBackupType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getManualBackupBucketName() {
        return this.manualBackupBucketName;
    }

    public ManualBackupType getManualBackupType() {
        return this.manualBackupType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutonomousDatabaseBackupConfig(");
        sb.append("super=").append(super.toString());
        sb.append("manualBackupBucketName=").append(String.valueOf(this.manualBackupBucketName));
        sb.append(", manualBackupType=").append(String.valueOf((Object)this.manualBackupType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutonomousDatabaseBackupConfig)) {
            return false;
        }
        AutonomousDatabaseBackupConfig other = (AutonomousDatabaseBackupConfig)((Object)o);
        return Objects.equals(this.manualBackupBucketName, other.manualBackupBucketName) && Objects.equals((Object)this.manualBackupType, (Object)other.manualBackupType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.manualBackupBucketName == null ? 43 : this.manualBackupBucketName.hashCode());
        result = result * 59 + (this.manualBackupType == null ? 43 : this.manualBackupType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ManualBackupType implements BmcEnum
    {
        None("NONE"),
        ObjectStore("OBJECT_STORE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ManualBackupType> map;

        private ManualBackupType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ManualBackupType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ManualBackupType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ManualBackupType.class);
            map = new HashMap<String, ManualBackupType>();
            for (ManualBackupType v : ManualBackupType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="manualBackupBucketName")
        private String manualBackupBucketName;
        @JsonProperty(value="manualBackupType")
        private ManualBackupType manualBackupType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder manualBackupBucketName(String manualBackupBucketName) {
            this.manualBackupBucketName = manualBackupBucketName;
            this.__explicitlySet__.add("manualBackupBucketName");
            return this;
        }

        public Builder manualBackupType(ManualBackupType manualBackupType) {
            this.manualBackupType = manualBackupType;
            this.__explicitlySet__.add("manualBackupType");
            return this;
        }

        public AutonomousDatabaseBackupConfig build() {
            AutonomousDatabaseBackupConfig model = new AutonomousDatabaseBackupConfig(this.manualBackupBucketName, this.manualBackupType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutonomousDatabaseBackupConfig model) {
            if (model.wasPropertyExplicitlySet("manualBackupBucketName")) {
                this.manualBackupBucketName(model.getManualBackupBucketName());
            }
            if (model.wasPropertyExplicitlySet("manualBackupType")) {
                this.manualBackupType(model.getManualBackupType());
            }
            return this;
        }
    }
}

