/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seembedded.project;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.java.j2seembedded.platform.RemotePlatform;
import org.netbeans.modules.java.j2seembedded.project.RemotePlatformProjectSaver;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.cookies.CloseCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;

final class Utilities {
    private static final String TARGET_RUN = "$target.run";
    private static final String TARGET_DEBUG = "$target.debug";
    private static final String TARGET_PROFILE = "$target.profile";
    private static final String COS_DISABLE = "compile.on.save.unsupported.remote.platform";
    private static final String DEBUG_TRANSPORT = "debug-transport";
    private static final String EXTENSION_NAME = "remote-platform-1";
    private static final String[] OLD_EXTENSION_NAMES = new String[0];
    private static final String BUILD_SCRIPT_PATH = "nbproject/remote-platform-impl.xml";
    private static final String BUILD_SCRIPT_BACK_UP = "remote-platform-impl_backup";
    private static final String BUILD_SCRIPT_PROTOTYPE = "/org/netbeans/modules/java/j2seembedded/resources/remote-platform-impl.xml";
    private static final Map<String, String> CONFIG_PROPERTIES;
    private static final Set<String> REMOVE_CONFIG_PROPERTIES;
    private static final String PLATFORM_RUNTIME = "platform.runtime";
    private static final Logger LOG;
    private static volatile Long templateCRCCache;

    private Utilities() {
        throw new IllegalStateException();
    }

    @CheckForNull
    static RemotePlatform getRemotePlatform(@NonNull Project prj) {
        PropertyEvaluator eval = ((J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class)).evaluator();
        String rpid = eval.getProperty(PLATFORM_RUNTIME);
        if (rpid == null || rpid.isEmpty()) {
            return null;
        }
        return Utilities.findRemotePlatform(rpid);
    }

    static boolean hasRemotePlatform(@NonNull Project prj) {
        PropertyEvaluator eval = ((J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class)).evaluator();
        String rpid = eval.getProperty(PLATFORM_RUNTIME);
        return rpid != null && !rpid.isEmpty() && Utilities.findRemotePlatform(rpid) != null;
    }

    static UpdateConfigResult updateRemotePlatformConfigurations(final @NonNull Project prj) throws IOException {
        try {
            return (UpdateConfigResult)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<UpdateConfigResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public UpdateConfigResult run() throws Exception {
                    FileObject cfgFolder;
                    HashSet<String> updated = new HashSet<String>();
                    HashSet<String> upToDate = new HashSet<String>();
                    FileObject prjDir = prj.getProjectDirectory();
                    if (prjDir != null && (cfgFolder = prjDir.getFileObject("nbproject/configs")) != null) {
                        for (FileObject cfgFile : cfgFolder.getChildren()) {
                            OutputStream out;
                            FileLock lock;
                            String relPath;
                            if (!cfgFile.hasExt("properties") || (relPath = FileUtil.getRelativePath((FileObject)prjDir, (FileObject)cfgFile)) == null) continue;
                            EditableProperties ep = new EditableProperties(true);
                            try (InputStream in = cfgFile.getInputStream();){
                                ep.load(in);
                            }
                            String runtimePlatform = ep.getProperty(Utilities.PLATFORM_RUNTIME);
                            if (runtimePlatform != null && !runtimePlatform.isEmpty()) {
                                if (Utilities.configAlreadyUpdated(ep, true)) {
                                    upToDate.add(relPath);
                                    continue;
                                }
                                Utilities.extendConfig(ep);
                                lock = cfgFile.lock();
                                try {
                                    out = cfgFile.getOutputStream(lock);
                                    try {
                                        ep.store(out);
                                    }
                                    finally {
                                        if (out != null) {
                                            out.close();
                                        }
                                    }
                                }
                                finally {
                                    lock.releaseLock();
                                }
                                updated.add(relPath);
                                continue;
                            }
                            if (!Utilities.configAlreadyUpdated(ep, false)) continue;
                            Utilities.clearConfig(ep);
                            lock = cfgFile.lock();
                            try {
                                out = cfgFile.getOutputStream(lock);
                                try {
                                    ep.store(out);
                                }
                                finally {
                                    if (out != null) {
                                        out.close();
                                    }
                                }
                            }
                            finally {
                                lock.releaseLock();
                            }
                        }
                    }
                    return new UpdateConfigResult(updated, upToDate);
                }
            });
        }
        catch (MutexException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    static boolean hasRemoteExtension(@NonNull Project project) {
        AntBuildExtender extender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
        if (extender == null) {
            return false;
        }
        return extender.getExtension(EXTENSION_NAME) != null;
    }

    static boolean removeOldRemoteExtensions(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        boolean result = false;
        AntBuildExtender extender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
        if (extender != null) {
            for (String oldExtensionName : OLD_EXTENSION_NAMES) {
                if (extender.getExtension(oldExtensionName) == null) continue;
                extender.removeExtension(oldExtensionName);
                result = true;
            }
        }
        return result;
    }

    static void addRemoteExtension(@NonNull Project project) throws IOException {
        AntBuildExtender extender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
        if (extender == null) {
            LOG.log(Level.WARNING, "The project {0} ({1}) does not support AntBuildExtender.", new Object[]{ProjectUtils.getInformation((Project)project).getDisplayName(), FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory())});
            return;
        }
        FileObject rpBuildScript = Utilities.copyBuildScript(project);
        extender.addExtension(EXTENSION_NAME, rpBuildScript);
    }

    @NonNull
    static FileObject copyBuildScript(@NonNull Project project) throws IOException {
        FileObject projDir = project.getProjectDirectory();
        FileObject rpBuildScript = projDir.getFileObject(BUILD_SCRIPT_PATH);
        if (rpBuildScript != null && !Utilities.isBuildScriptUpToDate(project)) {
            FileObject nbproject;
            FileObject backupFile;
            DataObject dobj = DataObject.find((FileObject)rpBuildScript);
            CloseCookie closeCookie = (CloseCookie)dobj.getLookup().lookup(CloseCookie.class);
            if (closeCookie != null) {
                closeCookie.close();
            }
            if ((backupFile = (nbproject = projDir.getFileObject("nbproject")).getFileObject(BUILD_SCRIPT_BACK_UP, "xml")) != null) {
                backupFile.delete();
            }
            FileUtil.moveFile((FileObject)rpBuildScript, (FileObject)nbproject, (String)BUILD_SCRIPT_BACK_UP);
            rpBuildScript = null;
        }
        if (rpBuildScript == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Updating remote build script in project {0} ({1})", new Object[]{ProjectUtils.getInformation((Project)project).getDisplayName(), FileUtil.getFileDisplayName((FileObject)projDir)});
            }
            rpBuildScript = FileUtil.createData((FileObject)project.getProjectDirectory(), (String)BUILD_SCRIPT_PATH);
            try (BufferedInputStream in = new BufferedInputStream(RemotePlatformProjectSaver.class.getResourceAsStream(BUILD_SCRIPT_PROTOTYPE));
                 BufferedOutputStream out = new BufferedOutputStream(rpBuildScript.getOutputStream());){
                FileUtil.copy((InputStream)in, (OutputStream)out);
            }
        }
        return rpBuildScript;
    }

    protected static String getTargetOSForRP(@NonNull String os, @NonNull String arch, @NullAllowed String abi, @NonNull String vmName) {
        String targetOS;
        if (os.toLowerCase().contains("win")) {
            targetOS = "win";
            if (arch.toLowerCase().contains("64")) {
                targetOS = targetOS + "amd64-15";
            } else if (arch.toLowerCase().contains("86")) {
                targetOS = targetOS + "-15";
            } else if ("CVM".equals(vmName)) {
                targetOS = targetOS + "cvm";
            }
        } else if (os.toLowerCase().contains("linux")) {
            targetOS = "linux";
            if (arch.toLowerCase().contains("arm")) {
                targetOS = targetOS + "arm";
                if (abi != null && abi.toLowerCase().contains("abihf")) {
                    targetOS = targetOS + "vfphflt";
                }
                targetOS = targetOS + "-15";
            } else if (arch.toLowerCase().contains("64")) {
                targetOS = targetOS + "amd64-15";
            } else if (arch.toLowerCase().contains("86")) {
                targetOS = targetOS + "-15";
            } else if ("CVM".equals(vmName)) {
                targetOS = targetOS + "cvm";
            }
        } else if (os.toLowerCase().contains("sol")) {
            targetOS = "sol";
            if (arch.toLowerCase().contains("sparc")) {
                targetOS = targetOS + "sparc";
                if (arch.toLowerCase().contains("v9")) {
                    targetOS = targetOS + "v9";
                }
            } else if (arch.toLowerCase().contains("64")) {
                targetOS = targetOS + "amd64";
            } else if (arch.toLowerCase().contains("86")) {
                targetOS = targetOS + "x86";
            }
            targetOS = targetOS + "-15";
        } else {
            targetOS = os.toLowerCase().contains("mac") ? "mac-15" : "";
        }
        return targetOS;
    }

    private static RemotePlatform findRemotePlatform(@NonNull String platformId) {
        JavaPlatform[] platforms;
        Parameters.notNull((CharSequence)"platformId", (Object)platformId);
        for (JavaPlatform platform : platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se-remote", null))) {
            String antPlatformName = (String)platform.getProperties().get("platform.ant.name");
            if (!platformId.equals(antPlatformName) || !(platform instanceof RemotePlatform)) continue;
            return (RemotePlatform)platform;
        }
        return null;
    }

    private static boolean isBuildScriptUpToDate(@NonNull Project project) {
        FileObject prjDir = project.getProjectDirectory();
        if (prjDir == null) {
            return false;
        }
        FileObject remoteBuildScript = prjDir.getFileObject(BUILD_SCRIPT_PATH);
        if (remoteBuildScript == null) {
            return false;
        }
        try {
            long scriptCRC;
            try (BufferedInputStream in = new BufferedInputStream(remoteBuildScript.getInputStream());){
                scriptCRC = Utilities.calculateCRC(in);
            }
            Long templateCRC = templateCRCCache;
            if (templateCRC == null) {
                try (BufferedInputStream in = new BufferedInputStream(RemotePlatformProjectSaver.class.getResourceAsStream(BUILD_SCRIPT_PROTOTYPE));){
                    templateCRCCache = templateCRC = Long.valueOf(Utilities.calculateCRC(in));
                }
            }
            return scriptCRC == templateCRC;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private static long calculateCRC(@NonNull InputStream in) throws IOException {
        int curr;
        CRC32 crc = new CRC32();
        int last = -1;
        while ((curr = in.read()) != -1) {
            if (curr != 10 && last == 13) {
                crc.update(10);
            }
            if (curr != 13) {
                crc.update(curr);
            }
            last = curr;
        }
        if (last == 13) {
            crc.update(10);
        }
        return crc.getValue();
    }

    private static boolean configAlreadyUpdated(@NonNull EditableProperties props, boolean fullCheck) {
        for (Map.Entry<String, String> e : CONFIG_PROPERTIES.entrySet()) {
            if (!fullCheck && !REMOVE_CONFIG_PROPERTIES.contains(e.getKey()) || e.getValue().equals(props.get((Object)e.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static void extendConfig(@NonNull EditableProperties props) {
        for (Map.Entry<String, String> e : CONFIG_PROPERTIES.entrySet()) {
            props.setProperty(e.getKey(), e.getValue());
        }
    }

    private static void clearConfig(@NonNull EditableProperties props) {
        for (String key : REMOVE_CONFIG_PROPERTIES) {
            props.remove((Object)key);
        }
    }

    static {
        REMOVE_CONFIG_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(TARGET_RUN, TARGET_DEBUG, TARGET_PROFILE)));
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(TARGET_RUN, "run-remote");
        m.put(TARGET_DEBUG, "debug-remote");
        m.put(TARGET_PROFILE, "profile-remote");
        m.put(COS_DISABLE, Boolean.TRUE.toString());
        m.put(DEBUG_TRANSPORT, "dt_socket");
        CONFIG_PROPERTIES = Collections.unmodifiableMap(m);
        LOG = Logger.getLogger(Utilities.class.getName());
    }

    static final class UpdateConfigResult {
        private final Collection<String> updated;
        private final Collection<String> upToDate;

        private UpdateConfigResult(@NonNull Collection<String> updated, @NonNull Collection<String> upToDate) {
            Parameters.notNull((CharSequence)"updated", updated);
            Parameters.notNull((CharSequence)"upToDate", upToDate);
            this.updated = Collections.unmodifiableCollection(updated);
            this.upToDate = Collections.unmodifiableCollection(upToDate);
        }

        @NonNull
        Collection<String> getUpdatedConfigs() {
            return this.updated;
        }

        @NonNull
        Collection<String> getUpToDateConfigs() {
            return this.upToDate;
        }

        boolean hasRemotePlatform() {
            return !this.updated.isEmpty() || !this.upToDate.isEmpty();
        }
    }
}

