/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.runjar;

import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.api.execute.ActiveJ2SEPlatformProvider;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.runjar.Bundle;
import org.netbeans.modules.maven.runjar.MainClassChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class RunJarPrereqChecker
implements PrerequisitesChecker {
    private static final String[] MAIN_CLASS_PROPERTIES = new String[]{"mainClass", "exec.mainClass", "project.mainClass", "project.mainclass"};
    private String mainClass;
    private static String testedMainClass;

    public static void setMainClass(String mainClass) {
        testedMainClass = mainClass;
    }

    @Override
    public boolean checkRunConfig(RunConfig config) {
        String actionName = config.getActionName();
        String tool = config.getProperties().get("exec.executable");
        if ("java".equals(tool)) {
            ActiveJ2SEPlatformProvider plat = (ActiveJ2SEPlatformProvider)config.getProject().getLookup().lookup(ActiveJ2SEPlatformProvider.class);
            assert (plat != null);
            FileObject fo = plat.getJavaPlatform().findTool(tool);
            if (fo != null) {
                File fl = FileUtil.toFile((FileObject)fo);
                config.setProperty("exec.executable", fl.getAbsolutePath());
            }
        }
        if ("run".equals(actionName) || "debug".equals(actionName) || "profile".equals(actionName)) {
            String mc = RunJarPrereqChecker.findMainClass(config);
            for (Map.Entry<? extends String, ? extends String> entry : config.getProperties().entrySet()) {
                if (!entry.getValue().contains("${packageClassName}")) continue;
                if (mc == null) {
                    if (this.mainClass != null) {
                        mc = this.mainClass;
                    } else if (testedMainClass != null) {
                        mc = this.mainClass = testedMainClass;
                    } else if (!GraphicsEnvironment.isHeadless() && (mc = this.showMainClassDialog(config.getProject(), actionName)) == null) {
                        return false;
                    }
                }
                if (mc == null) continue;
                config.setProperty(entry.getKey(), entry.getValue().replace("${packageClassName}", mc));
                config.setProperty("exec.mainClass", mc);
            }
        }
        return true;
    }

    private static String findMainClass(RunConfig config) {
        String mainClass = RunJarPrereqChecker.getConfiguration(config, "maven-jar-plugin", "archive", "manifest", "mainClass");
        if (mainClass != null) {
            return mainClass;
        }
        mainClass = RunJarPrereqChecker.getConfiguration(config, "exec-maven-plugin", "mainClass");
        if (mainClass != null) {
            return mainClass;
        }
        Properties properties = config.getMavenProject().getProperties();
        for (String name : MAIN_CLASS_PROPERTIES) {
            String mc = properties.getProperty(name);
            if (mc == null) continue;
            return mc;
        }
        return null;
    }

    private static Plugin findPlugin(RunConfig config, String name) {
        List plugins = config.getMavenProject().getBuild().getPlugins();
        for (Plugin p : plugins) {
            if (!name.equals(p.getArtifactId())) continue;
            return p;
        }
        return null;
    }

    private static String getConfiguration(RunConfig config, String pluginId, String ... configs) {
        Xpp3Dom configuration;
        Plugin plugin = RunJarPrereqChecker.findPlugin(config, pluginId);
        if (plugin != null && (configuration = (Xpp3Dom)plugin.getConfiguration()) != null) {
            String c;
            Xpp3Dom child = configuration;
            String[] stringArray = configs;
            int n = stringArray.length;
            for (int i = 0; i < n && (child = child.getChild(c = stringArray[i])) != null; ++i) {
            }
            if (child != null) {
                return child.getValue();
            }
        }
        return null;
    }

    private String showMainClassDialog(Project project, String actionName) {
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        Sources srcs = ProjectUtils.getSources((Project)project);
        for (SourceGroup sourceGroup : srcs.getSourceGroups("java")) {
            if (!"1SourceRoot".equals(sourceGroup.getName())) continue;
            roots.add(sourceGroup.getRootFolder());
        }
        for (SourceGroup sourceGroup : srcs.getSourceGroups("GeneratedSources")) {
            roots.add(sourceGroup.getRootFolder());
        }
        final JButton okButton = new JButton(Bundle.LBL_ChooseMainClass_OK());
        final MainClassChooser panel = new MainClassChooser(roots.toArray(new FileObject[0]));
        Object[] options = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
        panel.addChangeListener(new ChangeListener(){
            final /* synthetic */ RunJarPrereqChecker this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                    okButton.doClick();
                } else {
                    okButton.setEnabled(panel.getSelectedMainClass() != null);
                }
            }
        });
        panel.rbSession.setSelected(true);
        okButton.setEnabled(false);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, Bundle.LBL_ChooseMainClass_Title(), true, options, options[0], 0, null, null);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
        dlg.setVisible(true);
        if (okButton == desc.getValue()) {
            if (panel.rbSession.isSelected()) {
                this.mainClass = panel.getSelectedMainClass();
            } else if (panel.rbPermanent.isSelected()) {
                RunJarPrereqChecker.writeMapping(actionName, project, panel.getSelectedMainClass());
            }
            return panel.getSelectedMainClass();
        }
        return null;
    }

    static void writeMapping(String actionName, Project project, String clazz) {
        try {
            M2ConfigProvider usr = (M2ConfigProvider)project.getLookup().lookup(M2ConfigProvider.class);
            NetbeansActionMapping mapp = ModelHandle2.getMapping(actionName, project, usr.getActiveConfiguration());
            if (mapp == null) {
                mapp = ModelHandle2.getDefaultMapping(actionName, project);
            }
            for (Map.Entry<String, String> e : mapp.getProperties().entrySet()) {
                String val = e.getValue();
                if (!val.contains("${packageClassName}")) continue;
                e.setValue(val.replace("${packageClassName}", clazz));
            }
            ModelHandle2.putMapping(mapp, project, usr.getActiveConfiguration());
        }
        catch (Exception e) {
            Exceptions.attachMessage((Throwable)e, (String)"Cannot persist action configuration.");
            Exceptions.printStackTrace((Throwable)e);
        }
    }
}

