/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.netbeans.modules.payara.tooling.PayaraIdeException;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpClass;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpCreateJDBCResource;
import org.netbeans.modules.payara.tooling.admin.RunnerRestClass;
import org.netbeans.modules.payara.tooling.admin.RunnerRestCreateJDBCResource;
import org.netbeans.modules.payara.tooling.admin.ServerAdmin;
import org.netbeans.modules.payara.tooling.data.PayaraServer;

@RunnerHttpClass(runner=RunnerHttpCreateJDBCResource.class)
@RunnerRestClass(runner=RunnerRestCreateJDBCResource.class)
public class CommandCreateJDBCResource
extends Command {
    private static final String COMMAND = "create-jdbc-resource";
    private static final String ERROR_MESSAGE = "Create JDBC resource failed.";
    final String connectionPoolId;
    final String jndiName;
    final String target;
    final Map<String, String> properties;

    public static ResultString createJDBCResource(PayaraServer server, String connectionPoolId, String jndiName, String target, Map<String, String> properties) throws PayaraIdeException {
        CommandCreateJDBCResource command = new CommandCreateJDBCResource(connectionPoolId, jndiName, target, properties);
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new PayaraIdeException(ERROR_MESSAGE, ie);
        }
    }

    public static ResultString createJDBCResource(PayaraServer server, String connectionPoolId, String jndiName, String target, Map<String, String> properties, long timeout) throws PayaraIdeException {
        CommandCreateJDBCResource command = new CommandCreateJDBCResource(connectionPoolId, jndiName, target, properties);
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new PayaraIdeException(ERROR_MESSAGE, ie);
        }
        catch (TimeoutException te) {
            throw new PayaraIdeException("Create JDBC resource failed. in " + timeout + "ms", te);
        }
    }

    public CommandCreateJDBCResource(String connectionPoolId, String jndiName, String target, Map<String, String> properties) {
        super(COMMAND);
        this.connectionPoolId = connectionPoolId;
        this.jndiName = jndiName;
        this.target = target;
        this.properties = properties;
    }
}

