/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSOperation;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSParameter;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SoapClientOperationInfo {
    private WsdlSaasMethod method;
    private String categoryName;
    private String serviceName;
    private String portName;
    private String operationName;
    private String wsdlUrl;
    private Project project;
    private WsdlData webServiceData;
    private WSService service;
    private WSOperation operation;
    private WSPort port;
    private List<ParameterInfo> headerParams = Collections.emptyList();

    public SoapClientOperationInfo(WsdlSaasMethod m, Project project) {
        this.method = m;
        this.categoryName = m.getSaas().getParentGroup().getName();
        this.serviceName = m.getSaas().getDefaultServiceName();
        this.project = project;
        this.method.getSaas().toStateReady(true);
        this.webServiceData = this.method.getSaas().getWsdlData();
        this.portName = this.method.getWsdlPort().getName();
        this.operationName = this.method.getWsdlOperation().getName();
        this.wsdlUrl = this.method.getSaas().getUrl();
        this.service = this.method.getSaas().getWsdlModel();
        this.port = this.method.getWsdlPort();
        this.operation = this.method.getWsdlOperation();
    }

    public Project getProject() {
        return this.project;
    }

    public WsdlSaasMethod getMethod() {
        return this.method;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getWsdlURL() {
        return this.wsdlUrl;
    }

    public String getWsdlLocation() {
        this.initWsdlModelInfo();
        return this.webServiceData.getWsdlFile();
    }

    public void initWsdlModelInfo() {
    }

    public static WSOperation findOperationByName(WSPort port, String name) {
        for (Object o : port.getOperations()) {
            if (!name.equals(((WSOperation)o).getName())) continue;
            return (WSOperation)o;
        }
        return null;
    }

    public WSPort getPort() {
        this.initWsdlModelInfo();
        return this.port;
    }

    public WSOperation getOperation() {
        this.initWsdlModelInfo();
        return this.operation;
    }

    public WSService getService() {
        this.initWsdlModelInfo();
        return this.service;
    }

    public List<WSParameter> getOutputParameters() {
        ArrayList<WSParameter> params = new ArrayList<WSParameter>();
        for (WSParameter p : this.getOperation().getParameters()) {
            if (!p.isHolder()) continue;
            params.add(p);
        }
        return params;
    }

    public static String getParamType(WSParameter param) {
        if (param.isHolder()) {
            String outputType = param.getTypeName();
            int iLT = outputType.indexOf(60);
            int iGT = outputType.indexOf(62);
            if (iLT > 0 || iGT > 0) {
                outputType = outputType.substring(iLT + 1, iGT).trim();
            }
            return outputType;
        }
        return param.getTypeName();
    }

    public String getOutputType() {
        String outputType = this.getOperation().getReturnTypeName();
        if ("void".equals(outputType)) {
            for (WSParameter p : this.getOperation().getParameters()) {
                if (!p.isHolder()) continue;
                outputType = SoapClientOperationInfo.getParamType(p);
                break;
            }
        }
        return outputType;
    }

    public String[] getInputParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (WSParameter p : this.getOperation().getParameters()) {
            if (p.isHolder()) continue;
            names.add(p.getName());
        }
        return names.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class[] getInputParameterTypes() {
        ArrayList<Class> types = new ArrayList<Class>();
        for (WSParameter p : this.getOperation().getParameters()) {
            if (p.isHolder()) continue;
            Class type = null;
            SoapClientOperationInfo soapClientOperationInfo = this;
            synchronized (soapClientOperationInfo) {
                try {
                    for (int repeatCount = 0; repeatCount < 60 && (type = this.getType(this.project, p.getTypeName())) == null; ++repeatCount) {
                        this.wait(2000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (type == null) {
                type = Object.class;
            }
            types.add(type);
        }
        return types.toArray(new Class[0]);
    }

    public Class getType(Project project, String typeName) {
        return Util.getType(project, typeName);
    }

    public boolean needsSoapHandler() {
        return this.getSoapHeaderParameters().size() > 0;
    }

    public List<ParameterInfo> getSoapHeaderParameters() {
        return this.headerParams;
    }

    public WSDLModel getXamWsdlModel() {
        try {
            FileObject wsdlFO = FileUtil.toFileObject((File)new File(this.webServiceData.getWsdlFile()));
            return WSDLModelFactory.getDefault().getModel(Utilities.createModelSource((FileObject)wsdlFO, (boolean)true));
        }
        catch (CatalogModelException ex) {
            Logger.getGlobal().log(Level.INFO, "", ex);
            return null;
        }
    }

    public boolean isRPCEncoded() {
        WSDLModel wsdlModel = this.getXamWsdlModel();
        return Util.isRPCEncoded(wsdlModel);
    }
}

