/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.runtime.LibTruffleAttachResource;
import com.oracle.truffle.runtime.ModulesAccessor;
import java.lang.module.ModuleDescriptor;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public final class ModulesSupport {
    private static final boolean ATTACH_AVAILABLE;
    private static final ModulesAccessor ACCESSOR;

    private static boolean isClassIsolationDisabled() {
        return Boolean.parseBoolean(System.getProperty("polyglotimpl.DisableClassPathIsolation", "true"));
    }

    private ModulesSupport() {
    }

    public static String exportJVMCI(Class<?> toClass) {
        Module previousModule = null;
        HashSet<Module> seenModules = new HashSet<Module>();
        for (Class<?> currentClass = toClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            String s;
            Module currentModule = currentClass.getModule();
            if (!currentModule.equals(previousModule) && (s = ModulesSupport.exportJVMCI(currentModule, seenModules)) != null) {
                return s;
            }
            previousModule = currentModule;
        }
        return null;
    }

    public static String exportJVMCI(Module module) {
        return ModulesSupport.exportJVMCI(module, new HashSet<Module>());
    }

    private static String exportJVMCI(Module module, Set<Module> seenModules) {
        Module jvmciModule;
        ModuleLayer layer = module.getLayer();
        if (layer == null) {
            layer = ModuleLayer.boot();
        }
        if ((jvmciModule = (Module)layer.findModule("jdk.internal.vm.ci").orElse(null)) == null) {
            return "JVMCI is not enabled for this JVM. Enable JVMCI using -XX:+EnableJVMCI.";
        }
        if (!ATTACH_AVAILABLE) {
            return "The Truffle attach library is not available.";
        }
        ModulesSupport.addExportsRecursive(layer, jvmciModule, module, seenModules);
        return null;
    }

    private static void addExportsRecursive(ModuleLayer layer, Module sourceModule, Module exportTo, Set<Module> seenModules) {
        if (seenModules.contains(exportTo)) {
            return;
        }
        for (String pn : sourceModule.getPackages()) {
            ModulesSupport.addExports(sourceModule, pn, exportTo);
        }
        seenModules.add(exportTo);
        ModuleDescriptor descriptor = exportTo.getDescriptor();
        if (descriptor != null) {
            for (ModuleDescriptor.Requires requires : descriptor.requires()) {
                String name;
                Module requiredModule = layer.findModule(requires.name()).orElse(null);
                if (requiredModule == null || (name = requiredModule.getName()).startsWith("java.") || name.startsWith("jdk.")) continue;
                ModulesSupport.addExportsRecursive(layer, sourceModule, requiredModule, seenModules);
            }
        }
    }

    public static void addExports(Module base, String p, Module target) {
        if (target.isNamed()) {
            ACCESSOR.addExports(base, p, target);
        } else {
            ACCESSOR.addExportsToAllUnnamed(base, p);
        }
    }

    private static boolean loadModulesSupportLibrary() {
        String attachLibPath = System.getProperty("truffle.attach.library");
        try {
            if (attachLibPath == null) {
                Class<?> resourceCacheClass = Class.forName("com.oracle.truffle.polyglot.InternalResourceCache", false, ModulesSupport.class.getClassLoader());
                Method installRuntimeResource = resourceCacheClass.getDeclaredMethod("installRuntimeResource", InternalResource.class);
                installRuntimeResource.setAccessible(true);
                Path root = (Path)installRuntimeResource.invoke(null, new LibTruffleAttachResource());
                Path libAttach = root.resolve("bin").resolve(System.mapLibraryName("truffleattach"));
                attachLibPath = libAttach.toString();
            }
            System.load(attachLibPath);
            return true;
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    private static native void addExports0(Module var0, String var1, Module var2);

    static {
        if (ModulesSupport.isClassIsolationDisabled()) {
            ATTACH_AVAILABLE = ModulesSupport.loadModulesSupportLibrary();
        } else {
            boolean bl = ATTACH_AVAILABLE = ModulesSupport.class.getModule().isNamed() && ModulesSupport.loadModulesSupportLibrary();
        }
        if (ATTACH_AVAILABLE) {
            ACCESSOR = ModulesAccessor.create(ModulesSupport.class);
            ModulesSupport.addExports0(ModuleLayer.boot().findModule("java.base").orElseThrow(), "jdk.internal.module", ACCESSOR.getTargetModule());
        } else {
            ACCESSOR = null;
        }
    }
}

