/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.refactor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.micronaut.MicronautConfigProperties;
import org.netbeans.modules.micronaut.MicronautConfigUtilities;
import org.netbeans.modules.micronaut.completion.MicronautConfigCompletionProvider;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataGroup;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataSource;

public class MicronautRefactoringFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        Lookup lkp = refactoring.getRefactoringSource();
        TreePathHandle handle = (TreePathHandle)lkp.lookup(TreePathHandle.class);
        if (refactoring instanceof WhereUsedQuery && ((WhereUsedQuery)refactoring).getBooleanValue((Object)"FIND_REFERENCES") && handle != null) {
            return new MicronautWhereUsedRefactoringPlugin((WhereUsedQuery)refactoring);
        }
        return null;
    }

    private static class MicronautWhereUsedRefactoringPlugin
    implements RefactoringPlugin {
        private final WhereUsedQuery refactoring;

        public MicronautWhereUsedRefactoringPlugin(WhereUsedQuery refactoring) {
            this.refactoring = refactoring;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
        }

        public Problem prepare(RefactoringElementsBag refactoringElements) {
            Scope scope = (Scope)this.refactoring.getContext().lookup(Scope.class);
            if (scope != null) {
                HashSet<Project> projects = new HashSet<Project>();
                for (FileObject sourceRoot : scope.getSourceRoots()) {
                    Project p = FileOwnerQuery.getOwner((FileObject)sourceRoot);
                    if (p == null) continue;
                    projects.add(p);
                }
                try {
                    Info info = null;
                    for (Project project : projects) {
                        SourceGroup[] sourceGroups;
                        if (!MicronautConfigProperties.hasConfigMetadata(project)) continue;
                        for (SourceGroup sourceGroup : sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("resources")) {
                            FileObject rootFolder = sourceGroup.getRootFolder();
                            ArrayList<FileObject> configFiles = new ArrayList<FileObject>();
                            for (FileObject fo : rootFolder.getChildren()) {
                                if (!MicronautConfigUtilities.isMicronautConfigFile(fo)) continue;
                                configFiles.add(fo);
                            }
                            if (configFiles.isEmpty()) continue;
                            if (info == null) {
                                info = this.getInfo();
                            }
                            if (info.className == null || info.propertyName == null) continue;
                            for (ConfigurationMetadataGroup group : MicronautConfigProperties.getGroups(project).values()) {
                                ConfigurationMetadataSource source = group.getSources().get(info.className);
                                if (source == null) continue;
                                for (ConfigurationMetadataProperty property : source.getProperties().values()) {
                                    String name = property.getName().replace("-", "");
                                    if (!name.equalsIgnoreCase(info.propertyName)) continue;
                                    for (FileObject configFile : configFiles) {
                                        MicronautConfigUtilities.collectUsages(configFile, property.getId(), usage -> refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new WhereUsedRefactoringElement(usage.getFileObject(), usage.getStartOffset(), usage.getEndOffset(), usage.getText())));
                                    }
                                }
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        private Info getInfo() throws IOException {
            TreePathHandle handle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
            Info info = new Info();
            JavaSource source = JavaSource.forFileObject((FileObject)handle.getFileObject());
            if (source != null) {
                source.runUserActionTask(controller -> {
                    controller.toPhase(JavaSource.Phase.RESOLVED);
                    Element el = handle.resolveElement((CompilationInfo)controller);
                    if (el != null) {
                        if (el.getKind() == ElementKind.METHOD) {
                            if (el.getModifiers().contains((Object)Modifier.PUBLIC) && el.getSimpleName().toString().startsWith("set")) {
                                info.propertyName = el.getSimpleName().toString().substring(3);
                                info.className = ((TypeElement)el.getEnclosingElement()).getQualifiedName().toString();
                            }
                        } else if (el.getKind().isField()) {
                            TypeElement typeElement = controller.getElements().getTypeElement("io.micronaut.context.annotation.Property");
                            block0: for (AnnotationMirror annotationMirror : el.getAnnotationMirrors()) {
                                if (typeElement != annotationMirror.getAnnotationType().asElement()) continue;
                                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                                    if (!"name".contentEquals(entry.getKey().getSimpleName())) continue;
                                    info.propertyName = (String)entry.getValue().getValue();
                                    info.className = ((TypeElement)el.getEnclosingElement()).getQualifiedName().toString();
                                    continue block0;
                                }
                            }
                        }
                    }
                }, true);
            }
            return info;
        }

        private static class Info {
            private String className;
            private String propertyName;

            private Info() {
            }
        }
    }

    public static final class WhereUsedRefactoringElement
    extends SimpleRefactoringElementImplementation {
        private final FileObject fileObject;
        private final int startOffset;
        private final int endOffset;
        private final String text;

        private WhereUsedRefactoringElement(FileObject fileObject, int startOffset, int endOffset, String text) {
            this.fileObject = fileObject;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            StringBuilder sb = new StringBuilder();
            int idx = this.text.indexOf(58);
            if (idx < 0) {
                sb.append(this.text);
            } else {
                sb.append(MicronautConfigCompletionProvider.PROPERTY_NAME_COLOR).append("<b>");
                sb.append(this.text.substring(0, idx));
                sb.append("</b></font>");
                sb.append(this.text.substring(idx));
            }
            return sb.toString();
        }

        public void performChange() {
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.fileObject;
        }

        public PositionBounds getPosition() {
            try {
                EditorCookie.Observable obs;
                DataObject dobj = DataObject.find((FileObject)this.getParentFile());
                if (dobj != null && (obs = (EditorCookie.Observable)dobj.getCookie(EditorCookie.Observable.class)) instanceof CloneableEditorSupport) {
                    CloneableEditorSupport supp = (CloneableEditorSupport)obs;
                    return new PositionBounds(supp.createPositionRef(this.startOffset, Position.Bias.Forward), supp.createPositionRef(Math.max(this.startOffset, this.endOffset), Position.Bias.Forward));
                }
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }
    }
}

