/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.host;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.host.GuestToHostCodeCache;
import com.oracle.truffle.host.GuestToHostRootNode;
import com.oracle.truffle.host.HostContext;
import com.oracle.truffle.host.HostLanguage;
import com.oracle.truffle.host.HostObject;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;

@ExportLibrary(value=InteropLibrary.class)
final class HostProxy
implements TruffleObject {
    static final int LIMIT = 5;
    final Object proxy;
    final HostContext context;

    HostProxy(HostContext context, Object proxy) {
        this.context = context;
        this.proxy = proxy;
    }

    static Object withContext(Object obj, HostContext context) {
        if (obj instanceof HostProxy) {
            HostProxy hostObject = (HostProxy)obj;
            return new HostProxy(context, hostObject.proxy);
        }
        throw CompilerDirectives.shouldNotReachHere("Parameter must be HostProxy.");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HostProxy)) {
            return false;
        }
        return this.proxy == ((HostProxy)obj).proxy;
    }

    public int hashCode() {
        return System.identityHashCode(this.proxy);
    }

    @ExportMessage
    boolean isInstantiable(@Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        return cache.api.isProxyInstantiable(this.proxy);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object instantiate(Object[] arguments, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyInstantiable(this.proxy)) {
            Object[] convertedArguments = cache.language.access.toValues(this.context.internalContext, arguments);
            Object result = GuestToHostRootNode.guestToHostCall(library, cache.instantiate, this.context, this.proxy, convertedArguments);
            return this.context.toGuestValue(library, result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isExecutable(@Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        return cache.api.isProxyExecutable(this.proxy);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object execute(Object[] arguments, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyExecutable(this.proxy)) {
            Object[] convertedArguments = this.context.language.access.toValues(this.context.internalContext, arguments);
            Object result = GuestToHostRootNode.guestToHostCall(library, cache.execute, this.context, this.proxy, convertedArguments);
            return this.context.toGuestValue(library, result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isPointer(@Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        return cache.api.isProxyNativeObject(this.proxy);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    long asPointer(@CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyNativeObject(this.proxy)) {
            return (Long)GuestToHostRootNode.guestToHostCall(library, cache.asPointer, this.context, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean hasArrayElements(@Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        return cache.api.isProxyArray(this.proxy);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readArrayElement(long index, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyArray(this.proxy)) {
            Object result = GuestToHostRootNode.guestToHostCall(library, cache.arrayGet, this.context, this.proxy, index);
            return this.context.toGuestValue(library, result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void writeArrayElement(long index, Object value, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (!cache.api.isProxyArray(this.proxy)) {
            throw UnsupportedMessageException.create();
        }
        Object castValue = this.context.asValue(library, value);
        GuestToHostRootNode.guestToHostCall(library, cache.arraySet, this.context, this.proxy, index, castValue);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void removeArrayElement(long index, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException, InvalidArrayIndexException {
        if (cache.api.isProxyArray(this.proxy)) {
            boolean result = (Boolean)GuestToHostRootNode.guestToHostCall(library, cache.arrayRemove, this.context, this.proxy, index);
            if (!result) {
                throw InvalidArrayIndexException.create(index);
            }
        } else {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    long getArraySize(@CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyArray(this.proxy)) {
            return (Long)GuestToHostRootNode.guestToHostCall(library, cache.arraySize, this.context, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isArrayElementReadable"), @ExportMessage(name="isArrayElementModifiable"), @ExportMessage(name="isArrayElementRemovable")})
    @CompilerDirectives.TruffleBoundary
    boolean isArrayElementExisting(long index, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        if (cache.api.isProxyArray(this.proxy)) {
            long size = (Long)GuestToHostRootNode.guestToHostCall(library, cache.arraySize, this.context, this.proxy);
            return index >= 0L && index < size;
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isArrayElementInsertable(long index, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        if (cache.api.isProxyArray(this.proxy)) {
            long size = (Long)GuestToHostRootNode.guestToHostCall(library, cache.arraySize, this.context, this.proxy);
            return index < 0L || index >= size;
        }
        return false;
    }

    @ExportMessage
    boolean hasMembers(@Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        return cache.api.isProxyObject(this.proxy);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyObject(this.proxy)) {
            Object result = GuestToHostRootNode.guestToHostCall(library, cache.memberKeys, this.context, this.proxy);
            assert (result != null);
            Object guestValue = this.context.toGuestValue(library, result);
            InteropLibrary interop = InteropLibrary.getFactory().getUncached();
            if (!interop.hasArrayElements(guestValue)) {
                if (guestValue instanceof HostObject) {
                    HostObject hostObject = (HostObject)guestValue;
                    if (hostObject.obj.getClass().isArray() && !hostObject.getHostClassCache().isArrayAccess()) {
                        throw HostProxy.illegalProxy(this.context, "getMemberKeys() returned a Java array %s, but allowArrayAccess in HostAccess is false.", this.context.asValue(library, guestValue).toString());
                    }
                    if (hostObject.obj instanceof List && !hostObject.getHostClassCache().isListAccess()) {
                        throw HostProxy.illegalProxy(this.context, "getMemberKeys() returned a Java List %s, but allowListAccess in HostAccess is false.", this.context.asValue(library, guestValue).toString());
                    }
                }
                throw HostProxy.illegalProxy(this.context, "getMemberKeys() returned invalid value %s but must return an array of member key Strings.", this.context.asValue(library, guestValue).toString());
            }
            int i = 0;
            while ((long)i < interop.getArraySize(guestValue)) {
                try {
                    Object element = interop.readArrayElement(guestValue, i);
                    if (!interop.isString(element)) {
                        throw HostProxy.illegalProxy(this.context, "getMemberKeys() returned invalid value %s but must return an array of member key Strings.", this.context.asValue(library, guestValue).toString());
                    }
                }
                catch (UnsupportedOperationException e) {
                    CompilerDirectives.shouldNotReachHere(e);
                }
                catch (InvalidArrayIndexException e) {
                    // empty catch block
                }
                ++i;
            }
            return guestValue;
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException illegalProxy(HostContext context, String message, Object ... parameters) {
        throw context.hostToGuestException(new IllegalStateException(String.format(message, parameters)));
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readMember(String member, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException, UnknownIdentifierException {
        if (cache.api.isProxyObject(this.proxy)) {
            if (!this.isMemberExisting(member, library, cache)) {
                throw UnknownIdentifierException.create(member);
            }
            Object result = GuestToHostRootNode.guestToHostCall(library, cache.getMember, this.context, this.proxy, member);
            return this.context.toGuestValue(library, result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void writeMember(String member, Object value, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (!cache.api.isProxyObject(this.proxy)) {
            throw UnsupportedMessageException.create();
        }
        Object castValue = this.context.asValue(library, value);
        GuestToHostRootNode.guestToHostCall(library, cache.putMember, this.context, this.proxy, member, castValue);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object invokeMember(String member, Object[] arguments, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="executables") @CachedLibrary(limit="LIMIT") InteropLibrary executables, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException, UnsupportedTypeException, ArityException, UnknownIdentifierException {
        if (cache.api.isProxyObject(this.proxy)) {
            Object memberObject;
            if (!this.isMemberExisting(member, library, cache)) {
                throw UnknownIdentifierException.create(member);
            }
            try {
                memberObject = this.readMember(member, library, cache);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
            memberObject = this.context.toGuestValue(library, memberObject);
            if (executables.isExecutable(memberObject)) {
                return executables.execute(memberObject, arguments);
            }
            throw UnsupportedMessageException.create();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberInvocable(String member, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="executables") @CachedLibrary(limit="LIMIT") InteropLibrary executables, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        if (cache.api.isProxyObject(this.proxy) && this.isMemberExisting(member, library, cache)) {
            try {
                return executables.isExecutable(this.readMember(member, library, cache));
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                return false;
            }
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void removeMember(String member, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException, UnknownIdentifierException {
        if (cache.api.isProxyObject(this.proxy)) {
            if (!this.isMemberExisting(member, library, cache)) {
                throw UnknownIdentifierException.create(member);
            }
            boolean result = (Boolean)GuestToHostRootNode.guestToHostCall(library, cache.removeMember, this.context, this.proxy, member);
            if (!result) {
                throw UnknownIdentifierException.create(member);
            }
        } else {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isMemberReadable"), @ExportMessage(name="isMemberModifiable"), @ExportMessage(name="isMemberRemovable")})
    @CompilerDirectives.TruffleBoundary
    boolean isMemberExisting(String member, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        if (cache.api.isProxyObject(this.proxy)) {
            return (Boolean)GuestToHostRootNode.guestToHostCall(library, cache.hasMember, this.context, this.proxy, member);
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberInsertable(String member, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        if (cache.api.isProxyObject(this.proxy)) {
            return !this.isMemberExisting(member, library, cache);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    boolean isDate(@Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        return cache.api.isProxyDate(this.proxy);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    boolean isTime(@Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        return cache.api.isProxyTime(this.proxy);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    boolean isTimeZone(@Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        return cache.api.isProxyTimeZone(this.proxy);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    ZoneId asTimeZone(@CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyTimeZone(this.proxy)) {
            return (ZoneId)GuestToHostRootNode.guestToHostCall(library, cache.asTimezone, this.context, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalDate asDate(@CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyDate(this.proxy)) {
            return (LocalDate)GuestToHostRootNode.guestToHostCall(library, cache.asDate, this.context, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalTime asTime(@CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyTime(this.proxy)) {
            return (LocalTime)GuestToHostRootNode.guestToHostCall(library, cache.asTime, this.context, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    Instant asInstant(@CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyInstant(this.proxy)) {
            return (Instant)GuestToHostRootNode.guestToHostCall(library, cache.asInstant, this.context, this.proxy);
        }
        if (this.isDate(cache) && this.isTime(cache) && this.isTimeZone(cache)) {
            return ZonedDateTime.of(this.asDate(library, cache), this.asTime(library, cache), this.asTimeZone(library, cache)).toInstant();
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    boolean isDuration(@Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        return cache.api.isProxyDuration(this.proxy);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Duration asDuration(@CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyDuration(this.proxy)) {
            return (Duration)GuestToHostRootNode.guestToHostCall(library, cache.asDuration, this.context, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return HostLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean config) {
        try {
            return this.proxy.toString();
        }
        catch (Throwable t) {
            throw this.context.hostToGuestException(t);
        }
    }

    @ExportMessage
    boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    Object getMetaObject() {
        Class<?> javaObject = this.proxy.getClass();
        return HostObject.forClass(javaObject, this.context);
    }

    @ExportMessage
    boolean hasIterator(@Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        return cache.api.isProxyIterable(this.proxy);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getIterator(@CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyIterable(this.proxy)) {
            Object result = GuestToHostRootNode.guestToHostCall(library, cache.getIterator, this.context, this.proxy);
            Object guestValue = this.context.toGuestValue(library, result);
            InteropLibrary interop = InteropLibrary.getFactory().getUncached();
            if (!interop.isIterator(guestValue)) {
                throw HostProxy.illegalProxy(this.context, "getIterator() returned an invalid value %s but must return an iterator.", this.context.asValue(library, guestValue).toString());
            }
            return guestValue;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isIterator(@Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        return cache.api.isProxyIterator(this.proxy);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasIteratorNextElement(@CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyIterator(this.proxy)) {
            return (Boolean)GuestToHostRootNode.guestToHostCall(library, cache.hasIteratorNextElement, this.context, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getIteratorNextElement(@CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyIterator(this.proxy)) {
            Object result = GuestToHostRootNode.guestToHostCall(library, cache.getIteratorNextElement, this.context, this.proxy);
            return this.context.toGuestValue(library, result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasHashEntries(@Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        return cache.api.isProxyHashMap(this.proxy);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    long getHashSize(@CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyHashMap(this.proxy)) {
            return (Long)GuestToHostRootNode.guestToHostCall(library, cache.getHashSize, this.context, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isHashEntryReadable"), @ExportMessage(name="isHashEntryModifiable"), @ExportMessage(name="isHashEntryRemovable")})
    @CompilerDirectives.TruffleBoundary
    boolean isHashValueExisting(Object key, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        if (cache.api.isProxyHashMap(this.proxy)) {
            Object keyValue = this.context.asValue(library, key);
            return (Boolean)GuestToHostRootNode.guestToHostCall(library, cache.hasHashEntry, this.context, this.proxy, keyValue);
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readHashValue(Object key, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException, UnknownKeyException {
        if (cache.api.isProxyHashMap(this.proxy)) {
            if (!this.isHashValueExisting(key, library, cache)) {
                throw UnknownKeyException.create(key);
            }
            Object keyValue = this.context.asValue(library, key);
            Object result = GuestToHostRootNode.guestToHostCall(library, cache.getHashValue, this.context, this.proxy, keyValue);
            return this.context.toGuestValue(library, result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isHashEntryInsertable(Object key, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) {
        if (cache.api.isProxyHashMap(this.proxy)) {
            return !this.isHashValueExisting(key, library, cache);
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void writeHashEntry(Object key, Object value, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (!cache.api.isProxyHashMap(this.proxy)) {
            throw UnsupportedMessageException.create();
        }
        Object keyValue = this.context.asValue(library, key);
        Object valueValue = this.context.asValue(library, value);
        GuestToHostRootNode.guestToHostCall(library, cache.putHashEntry, this.context, this.proxy, keyValue, valueValue);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void removeHashEntry(Object key, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException, UnknownKeyException {
        if (cache.api.isProxyHashMap(this.proxy)) {
            if (!this.isHashValueExisting(key, library, cache)) {
                throw UnknownKeyException.create(key);
            }
        } else {
            throw UnsupportedMessageException.create();
        }
        Object keyValue = this.context.asValue(library, key);
        GuestToHostRootNode.guestToHostCall(library, cache.removeHashEntry, this.context, this.proxy, keyValue);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getHashEntriesIterator(@CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="cache") @Cached(value="this.context.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws UnsupportedMessageException {
        if (cache.api.isProxyHashMap(this.proxy)) {
            Object result = GuestToHostRootNode.guestToHostCall(library, cache.getHashEntriesIterator, this.context, this.proxy);
            Object guestValue = this.context.toGuestValue(library, result);
            InteropLibrary interop = InteropLibrary.getFactory().getUncached();
            if (!interop.isIterator(guestValue)) {
                throw HostProxy.illegalProxy(this.context, "getHashEntriesIterator() returned an invalid value %s but must return an iterator.", this.context.asValue(library, guestValue).toString());
            }
            return guestValue;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static int identityHashCode(HostProxy receiver) {
        return System.identityHashCode(receiver.proxy);
    }

    public static boolean isProxyGuestObject(HostLanguage language, TruffleObject value) {
        return HostProxy.isProxyGuestObject(language, (Object)value);
    }

    public static boolean isProxyGuestObject(HostLanguage language, Object value) {
        Object unwrapped = HostLanguage.unwrapIfScoped(language, value);
        return unwrapped instanceof HostProxy;
    }

    public static Object toProxyHostObject(HostLanguage language, Object value) {
        Object v = HostLanguage.unwrapIfScoped(language, value);
        return ((HostProxy)v).proxy;
    }

    public static TruffleObject toProxyGuestObject(HostContext context, Object receiver) {
        return new HostProxy(context, receiver);
    }

    @ExportMessage
    static final class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doHostObject(HostProxy receiver, HostProxy other) {
            return receiver.proxy == other.proxy ? TriState.TRUE : TriState.FALSE;
        }

        @Fallback
        static TriState doOther(HostProxy receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }
}

