/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.hudson.api.HudsonChangeAdapter;
import org.netbeans.modules.hudson.api.HudsonChangeListener;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonManager;
import org.netbeans.modules.hudson.api.Utilities;
import org.netbeans.modules.hudson.spi.HudsonManagerAgent;
import org.netbeans.modules.hudson.ui.notification.ProblemNotificationController;
import org.netbeans.modules.hudson.ui.spi.ProjectHudsonProvider;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class OpenProjectstHudsonManagerAgent
extends HudsonManagerAgent {
    private static final RequestProcessor RP = new RequestProcessor(OpenProjectstHudsonManagerAgent.class);
    private final PropertyChangeListener projectsListener;
    private final Map<Project, HudsonInstance> projectInstances = new HashMap<Project, HudsonInstance>();
    private final Map<HudsonInstance, ProblemNotificationController> notifications = new HashMap<HudsonInstance, ProblemNotificationController>();
    private final Map<HudsonInstance, List<Project>> instanceProviders = new HashMap<HudsonInstance, List<Project>>();
    private final RequestProcessor.Task checkOpenProjects = RP.create(new Runnable(){

        @Override
        public void run() {
            OpenProjectstHudsonManagerAgent.this.checkOpenProjects();
        }
    });

    public OpenProjectstHudsonManagerAgent() {
        this.projectsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("openProjects".equals(evt.getPropertyName())) {
                    OpenProjectstHudsonManagerAgent.this.checkOpenProjects.schedule(0);
                }
            }
        };
    }

    public void start() {
        OpenProjects.getDefault().addPropertyChangeListener(this.projectsListener);
        this.checkOpenProjects.schedule(0);
    }

    public void terminate() {
        OpenProjects.getDefault().removePropertyChangeListener(this.projectsListener);
        this.projectInstances.clear();
    }

    private synchronized void checkOpenProjects() {
        try {
            Project[] prjs;
            Future fut = OpenProjects.getDefault().openProjects();
            for (Project project : prjs = (Project[])fut.get()) {
                HudsonInstance remove;
                boolean exists = this.projectInstances.containsKey(project);
                ProjectHudsonProvider.Association assoc = ProjectHudsonProvider.getDefault().findAssociation(project);
                if (assoc != null && !exists) {
                    String url = assoc.getServerUrl();
                    if (!Utilities.checkHudsonURL((String)url).isOK()) continue;
                    HudsonInstance in = HudsonManager.getInstance((String)url);
                    if (in == null) {
                        String n = HudsonManager.simplifyServerLocation((String)url, (boolean)false);
                        in = HudsonManager.addInstance((String)n, (String)url, (int)60, (boolean)false);
                        if (assoc.getViewName() != null) {
                            in.prefs().put("view", assoc.getViewName());
                        }
                    }
                    this.addProvider(in, project);
                    this.projectInstances.put(project, in);
                    continue;
                }
                if (assoc != null || !exists || (remove = this.projectInstances.remove(project)) == null) continue;
                this.removeProvider(remove, project);
                if (this.hasProvider(remove)) continue;
                HudsonManager.removeInstance((HudsonInstance)remove);
            }
            ArrayList<Project> newprjs = new ArrayList<Project>(this.projectInstances.keySet());
            newprjs.removeAll(Arrays.asList(prjs));
            for (Project project : newprjs) {
                HudsonInstance remove = this.projectInstances.remove(project);
                if (remove == null || !this.hasProvider(remove) || remove.isPersisted()) continue;
                this.removeProvider(remove, project);
                if (this.hasProvider(remove)) continue;
                HudsonManager.removeInstance((HudsonInstance)remove);
            }
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void addProvider(HudsonInstance instance, Project project) {
        List<Project> providers = this.instanceProviders.get(instance);
        if (providers == null) {
            providers = new ArrayList<Project>();
            this.instanceProviders.put(instance, providers);
        }
        if (!providers.contains(project)) {
            providers.add(project);
        }
        this.setPreferredJobs(instance);
    }

    private void removeProvider(HudsonInstance instance, Project project) {
        List<Project> providers = this.instanceProviders.get(instance);
        if (providers != null) {
            providers.remove(project);
            if (providers.isEmpty()) {
                this.instanceProviders.remove(instance);
            }
        }
        this.setPreferredJobs(instance);
    }

    private boolean hasProvider(HudsonInstance instance) {
        List<Project> providers = this.instanceProviders.get(instance);
        if (providers == null) {
            return false;
        }
        if (providers.isEmpty()) {
            this.instanceProviders.remove(instance);
            return false;
        }
        return true;
    }

    private List<Project> getProviders(HudsonInstance instance) {
        return this.instanceProviders.get(instance);
    }

    private void setPreferredJobs(HudsonInstance instance) {
        List<Project> providers = this.getProviders(instance);
        if (providers == null) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Project prj : providers) {
            String name;
            ProjectHudsonProvider.Association assoc = ProjectHudsonProvider.getDefault().findAssociation(prj);
            if (assoc == null || (name = assoc.getJobName()) == null) continue;
            names.add(name);
        }
        instance.setPreferredJobs(names);
    }

    public void instanceAdded(HudsonInstance instance) {
        final ProblemNotificationController controller = new ProblemNotificationController(instance);
        instance.addHudsonChangeListener((HudsonChangeListener)new HudsonChangeAdapter(this){
            final /* synthetic */ OpenProjectstHudsonManagerAgent this$0;
            {
                this.this$0 = this$0;
            }

            public void contentChanged() {
                controller.updateNotifications();
            }
        });
        this.notifications.put(instance, controller);
    }

    public void instanceRemoved(HudsonInstance instance) {
        ProblemNotificationController c = this.notifications.remove(instance);
        if (c != null) {
            c.clearNotifications();
        }
    }
}

