/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import com.sun.nio.file.ExtendedOpenOption;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.OpenFlags;
import jnr.posix.POSIX;
import org.jruby.Ruby;
import org.jruby.platform.Platform;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.InvalidValueException;

public class ModeFlags
implements Cloneable {
    public static final int RDONLY = OpenFlags.O_RDONLY.intValue();
    public static final int WRONLY = OpenFlags.O_WRONLY.intValue();
    public static final int RDWR = OpenFlags.O_RDWR.intValue();
    public static final int CREAT = OpenFlags.O_CREAT.intValue();
    public static final int EXCL = OpenFlags.O_EXCL.intValue();
    public static final int TRUNC = OpenFlags.O_TRUNC.intValue();
    public static final int APPEND = OpenFlags.O_APPEND.intValue();
    public static final int NONBLOCK = OpenFlags.O_NONBLOCK.intValue();
    public static final int BINARY = OpenFlags.O_BINARY.defined() ? OpenFlags.O_BINARY.intValue() : 0;
    public static final int TMPFILE = OpenFlags.O_TMPFILE.defined() ? OpenFlags.O_TMPFILE.intValue() : 0;
    public static final int TEXT = 0x10000000;
    public static final int SHARE_DELETE = Platform.IS_WINDOWS ? 0x20000000 : 0;
    public static final OpenOption NOSHARE_DELETE;
    public static final int ACCMODE;
    private final int flags;
    private OpenOption[] openOptions;

    public ModeFlags() {
        this.flags = RDONLY;
    }

    public ModeFlags(long flags2) throws InvalidValueException {
        this.flags = (int)flags2;
    }

    public ModeFlags(String flagString) throws InvalidValueException {
        this.flags = ModeFlags.getOFlagsFromString(flagString);
    }

    public static int getOFlagsFromString(String modesString) throws InvalidValueException {
        int modes = 0;
        int length2 = modesString.length();
        if (length2 == 0) {
            throw new InvalidValueException();
        }
        switch (modesString.charAt(0)) {
            case 'r': {
                modes |= RDONLY;
                break;
            }
            case 'a': {
                modes |= APPEND | WRONLY | CREAT;
                break;
            }
            case 'w': {
                modes |= WRONLY | TRUNC | CREAT;
                break;
            }
            default: {
                throw new InvalidValueException();
            }
        }
        block12: for (int n = 1; n < length2; ++n) {
            switch (modesString.charAt(n)) {
                case 'b': {
                    modes |= BINARY;
                    continue block12;
                }
                case '+': {
                    modes = modes & ~ACCMODE | RDWR;
                    continue block12;
                }
                case 't': {
                    modes |= 0x10000000;
                    continue block12;
                }
                case 'x': {
                    modes |= EXCL;
                    continue block12;
                }
                case ':': {
                    break block12;
                }
                default: {
                    throw new InvalidValueException();
                }
            }
        }
        return modes;
    }

    public static int getOFlagsFromString(Ruby runtime2, String modesString) {
        try {
            return ModeFlags.getOFlagsFromString(modesString);
        }
        catch (InvalidValueException ive) {
            throw runtime2.newErrnoEINVALError("mode string: " + modesString);
        }
    }

    public static int oflagsFrom(POSIX posix, Channel channel) {
        int fileno2 = FilenoUtil.filenoFrom(channel);
        int mode2 = FilenoUtil.isFake(fileno2) || !posix.isNative() || Platform.IS_WINDOWS ? (channel instanceof ReadableByteChannel ? (channel instanceof WritableByteChannel ? RDWR : RDONLY) : (channel instanceof WritableByteChannel ? WRONLY : RDWR)) : posix.fcntl(fileno2, Fcntl.F_GETFL);
        return mode2;
    }

    @Deprecated
    public static ModeFlags getModesFromChannel(Channel channel) {
        try {
            ModeFlags modes = channel instanceof ReadableByteChannel ? (channel instanceof WritableByteChannel ? new ModeFlags(RDWR) : new ModeFlags(RDONLY)) : (channel instanceof WritableByteChannel ? new ModeFlags(WRONLY) : new ModeFlags(RDWR));
            return modes;
        }
        catch (InvalidValueException ive) {
            throw new RuntimeException(ive);
        }
    }

    public String toJavaModeString() {
        if (this.isWritable() || this.isCreate() || this.isTruncate()) {
            return "rw";
        }
        return "r";
    }

    public OpenOption[] toOpenOptions(boolean includeAppend, boolean includeTruncate) {
        int size2 = 0;
        boolean writable = false;
        boolean readable = false;
        if (this.isAppendable() || this.isWritable()) {
            writable = true;
        }
        if (this.isReadWrite() || !writable) {
            readable = true;
        }
        if (writable) {
            ++size2;
        }
        if (readable) {
            ++size2;
        }
        if (includeAppend && this.isAppendable()) {
            ++size2;
        }
        if (this.isCreate()) {
            ++size2;
        }
        if (includeTruncate && this.isTruncate()) {
            ++size2;
        }
        if (!this.isShareDelete() && NOSHARE_DELETE != null && Platform.IS_WINDOWS) {
            ++size2;
        }
        OpenOption[] options2 = new OpenOption[size2];
        int index2 = 0;
        if (writable) {
            options2[index2++] = StandardOpenOption.WRITE;
        }
        if (readable) {
            options2[index2++] = StandardOpenOption.READ;
        }
        if (includeAppend && this.isAppendable()) {
            options2[index2++] = StandardOpenOption.APPEND;
        }
        if (this.isCreate()) {
            options2[index2++] = StandardOpenOption.CREATE;
        }
        if (includeTruncate && this.isTruncate()) {
            options2[index2++] = StandardOpenOption.TRUNCATE_EXISTING;
        }
        if (!this.isShareDelete() && NOSHARE_DELETE != null && Platform.IS_WINDOWS) {
            options2[index2++] = NOSHARE_DELETE;
        }
        return options2;
    }

    public final boolean isReadOnly() {
        return (this.flags & WRONLY) == 0 && (this.flags & RDWR) == 0;
    }

    public boolean isReadable() {
        return (this.flags & RDWR) != 0 || this.isReadOnly();
    }

    public boolean isWriteOnly() {
        return (this.flags & WRONLY) != 0;
    }

    public boolean isReadWrite() {
        return (this.flags & RDWR) != 0;
    }

    public boolean isBinary() {
        return (this.flags & BINARY) != 0;
    }

    public boolean isText() {
        return (this.flags & 0x10000000) != 0;
    }

    public boolean isTemporary() {
        return (this.flags & TMPFILE) != 0;
    }

    public boolean isCreate() {
        return (this.flags & CREAT) != 0;
    }

    public boolean isWritable() {
        return (this.flags & RDWR) != 0 || (this.flags & WRONLY) != 0;
    }

    public boolean isExclusive() {
        return (this.flags & EXCL) != 0;
    }

    public boolean isAppendable() {
        return (this.flags & APPEND) != 0;
    }

    public boolean isTruncate() {
        return (this.flags & TRUNC) != 0;
    }

    public boolean isShareDelete() {
        return (this.flags & SHARE_DELETE) != 0;
    }

    public boolean isSubsetOf(ModeFlags superset) {
        return !(!superset.isReadable() && this.isReadable() || !superset.isWritable() && this.isWritable()) && (superset.isAppendable() || !this.isAppendable());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ModeFlags(").append(this.flags).append("): ");
        if (this.isAppendable()) {
            buf.append("APPENDABLE ");
        }
        if (this.isBinary()) {
            buf.append("BINARY ");
        }
        if (this.isCreate()) {
            buf.append("CREATE ");
        }
        if (this.isExclusive()) {
            buf.append("EXCLUSIVE ");
        }
        if (this.isReadOnly()) {
            buf.append("READONLY ");
        }
        if (this.isText()) {
            buf.append("TEXT ");
        }
        if (this.isTemporary()) {
            buf.append("TMPFILE ");
        }
        if (this.isTruncate()) {
            buf.append("TRUNCATE ");
        }
        if (this.isWritable()) {
            if (this.isReadable()) {
                buf.append("RDWR");
            } else {
                buf.append("WRITABLE ");
            }
        }
        return buf.toString();
    }

    public int getFlags() {
        return this.flags;
    }

    public static int getOpenFileFlagsFor(int flags2) {
        int readWrite = flags2 & 3;
        int fmodeFlags = readWrite == RDONLY ? 1 : (readWrite == WRONLY ? 2 : 3);
        if ((flags2 & APPEND) != 0) {
            fmodeFlags |= 0x40;
        }
        if ((flags2 & TRUNC) != 0) {
            fmodeFlags |= 0x800;
        }
        if ((flags2 & CREAT) != 0) {
            fmodeFlags |= 0x80;
        }
        if ((flags2 & BINARY) != 0) {
            fmodeFlags |= 4;
        }
        if ((flags2 & TMPFILE) != 0) {
            fmodeFlags |= 0x410000;
        }
        if ((flags2 & EXCL) != 0) {
            fmodeFlags |= 0x400;
        }
        if ((flags2 & 0x10000000) != 0) {
            fmodeFlags |= 0x1000;
        }
        return fmodeFlags;
    }

    public int getOpenFileFlags() {
        return ModeFlags.getOpenFileFlagsFor(this.flags);
    }

    public int getFcntlFileFlags() {
        int readWrite = this.flags & 3;
        int fcntlFlags = readWrite == RDONLY ? 0 : (readWrite == WRONLY ? 1 : 2);
        return fcntlFlags;
    }

    public static ModeFlags createModeFlags(int oflags) {
        try {
            return new ModeFlags(oflags);
        }
        catch (InvalidValueException e) {
            return new ModeFlags();
        }
    }

    static {
        ExtendedOpenOption noshareDelete = null;
        try {
            noshareDelete = ExtendedOpenOption.NOSHARE_DELETE;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        NOSHARE_DELETE = noshareDelete;
        ACCMODE = RDWR | WRONLY | RDONLY;
    }
}

