/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.ElementIterable;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.impl.Interval2IntTreeMap;
import org.gephi.graph.impl.TimeIndexImpl;
import org.gephi.graph.impl.TimeIndexStore;

public class IntervalIndexImpl<T extends Element>
extends TimeIndexImpl<T, Interval, IntervalSet, IntervalMap<?>> {
    public IntervalIndexImpl(TimeIndexStore<T, Interval, IntervalSet, IntervalMap<?>> store, boolean main) {
        super(store, main);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMinTimestamp() {
        this.lock();
        try {
            Interval2IntTreeMap sortedMap = (Interval2IntTreeMap)this.timestampIndexStore.timeSortedMap;
            if (this.mainIndex) {
                if (!sortedMap.isEmpty()) {
                    double d = sortedMap.getLow();
                    return d;
                }
            } else if (!sortedMap.isEmpty()) {
                for (Map.Entry<Interval, Integer> entry : sortedMap.entrySet()) {
                    TimeIndexImpl.TimeIndexEntry intervalEntry;
                    int index = entry.getValue();
                    if (index >= this.timestamps.length || (intervalEntry = this.timestamps[index]) == null) continue;
                    double d = entry.getKey().getLow();
                    return d;
                }
            }
            double d = Double.NEGATIVE_INFINITY;
            return d;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMaxTimestamp() {
        this.lock();
        try {
            Interval2IntTreeMap sortedMap;
            if (this.mainIndex) {
                sortedMap = (Interval2IntTreeMap)this.timestampIndexStore.timeSortedMap;
                if (!sortedMap.isEmpty()) {
                    double d = sortedMap.getHigh();
                    return d;
                }
            } else {
                sortedMap = (Interval2IntTreeMap)this.timestampIndexStore.timeSortedMap;
                if (!sortedMap.isEmpty()) {
                    double max = Double.NEGATIVE_INFINITY;
                    boolean found = false;
                    for (Map.Entry<Interval, Integer> entry : sortedMap.entrySet()) {
                        TimeIndexImpl.TimeIndexEntry intervalEntry;
                        int index = entry.getValue();
                        if (index >= this.timestamps.length || (intervalEntry = this.timestamps[index]) == null) continue;
                        found = true;
                        max = Math.max(max, entry.getKey().getHigh());
                    }
                    if (found) {
                        double d = max;
                        return d;
                    }
                }
            }
            double d = Double.POSITIVE_INFINITY;
            return d;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementIterable<T> get(double timestamp) {
        this.checkDouble(timestamp);
        this.lock();
        try {
            Object object;
            ObjectOpenHashSet elements = new ObjectOpenHashSet();
            Interval2IntTreeMap sortedMap = (Interval2IntTreeMap)this.timestampIndexStore.timeSortedMap;
            if (!sortedMap.isEmpty()) {
                for (Integer index : sortedMap.values(timestamp)) {
                    TimeIndexImpl.TimeIndexEntry ts;
                    if (index >= this.timestamps.length || (ts = this.timestamps[index]) == null) continue;
                    elements.addAll(ts.elementSet);
                }
            }
            if (!elements.isEmpty()) {
                object = new TimeIndexImpl.ElementSetWrapperIterable((Set<Element>)elements);
                return object;
            }
            object = ElementIterable.EMPTY;
            return object;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementIterable<T> get(Interval interval) {
        this.lock();
        try {
            Object object;
            ObjectOpenHashSet elements = new ObjectOpenHashSet();
            Interval2IntTreeMap sortedMap = (Interval2IntTreeMap)this.timestampIndexStore.timeSortedMap;
            if (!sortedMap.isEmpty()) {
                for (Integer index : sortedMap.values(interval)) {
                    TimeIndexImpl.TimeIndexEntry ts;
                    if (index >= this.timestamps.length || (ts = this.timestamps[index]) == null) continue;
                    elements.addAll(ts.elementSet);
                }
            }
            if (!elements.isEmpty()) {
                object = new TimeIndexImpl.ElementSetWrapperIterable((Set<Element>)elements);
                return object;
            }
            object = ElementIterable.EMPTY;
            return object;
        }
        finally {
            this.unlock();
        }
    }
}

