/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.AWTEvent;
import java.awt.ComponentOrientation;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.view.swing.map.outline.NodeButton;
import org.freeplane.view.swing.map.outline.OutlineGeometry;
import org.freeplane.view.swing.map.outline.OutlineSelection;
import org.freeplane.view.swing.map.outline.RightToLeftLayout;
import org.freeplane.view.swing.map.outline.ScrollableTreePanel;
import org.freeplane.view.swing.map.outline.SelectionPainter;
import org.freeplane.view.swing.map.outline.TimeDelayedOutlineSelection;
import org.freeplane.view.swing.map.outline.TreeNode;

class BlockPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = Boolean.getBoolean("org.freeplane.view.swing.map.outline.BlockPanel.DEBUG");
    private final OutlineSelection selection;
    private final List<TreeNode> nodes;
    private final int rowHeight;
    private final ScrollableTreePanel parentPanel;

    BlockPanel(List<TreeNode> nodes, int rowHeight, ComponentOrientation outlineTextOrientation, ScrollableTreePanel parentPanel, OutlineSelection selection) {
        this.setLayout(null);
        this.setOpaque(false);
        this.selection = selection;
        this.nodes = new ArrayList<TreeNode>(nodes);
        this.rowHeight = rowHeight;
        this.parentPanel = parentPanel;
        this.setComponentOrientation(outlineTextOrientation);
        this.rebuildNodeButtons();
    }

    void rebuildNodeButtons() {
        this.removeAll();
        int visibleButtonIndex = 0;
        ResourceController resourceController = ResourceController.getResourceController();
        boolean useColoredOutlineItems = resourceController.getBooleanProperty("useColoredOutlineItems", false);
        for (TreeNode node : this.nodes) {
            int y = visibleButtonIndex * this.rowHeight;
            this.createNodeButton(node, y, this.rowHeight, useColoredOutlineItems, this.parentPanel);
            ++visibleButtonIndex;
        }
        RightToLeftLayout.applyToContainer(this);
        this.revalidate();
        this.repaint();
    }

    private void createNodeButton(final TreeNode node, int y, int rowHeight, boolean useColoredOutlineItems, final ScrollableTreePanel parentPanel) {
        final NodeButton button = new NodeButton(node, useColoredOutlineItems, this.getComponentOrientation());
        if (DEBUG && useColoredOutlineItems) {
            button.setText("" + this.getComponentCount());
        }
        int computedLevel = node.getLevel();
        int actionX = OutlineGeometry.getInstance().calculateNodeButtonX(parentPanel.getDisplayMode().showsNavigationButtons(), computedLevel);
        button.setBounds(actionX, y, button.getPreferredSize().width, rowHeight);
        AbstractAction selectAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MouseEvent mouseEvent;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof MouseEvent && button.isFirstIconClick(mouseEvent = (MouseEvent)currentEvent)) {
                    parentPanel.toggleNodeExpansion(node);
                    return;
                }
                parentPanel.setSelectedNode(node, true);
                parentPanel.selectMapNodeById(node.getId());
            }
        };
        button.addActionListener(selectAction);
        InputMap im = button.getInputMap(0);
        ActionMap am = button.getActionMap();
        im.put(KeyStroke.getKeyStroke("ENTER"), "selectMapNode");
        am.put("selectMapNode", selectAction);
        im.put(KeyStroke.getKeyStroke("SPACE"), "toggleExpand");
        AbstractAction expandAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                parentPanel.toggleExpandSelected();
            }
        };
        am.put("toggleExpand", expandAction);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                parentPanel.onContentButtonHovered(node);
                TimeDelayedOutlineSelection.outlineSelector.handleMouseEvent(e);
            }
        });
        this.add(button);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int oldWidth = this.getWidth();
        RightToLeftLayout.onContainerWidthChange(this, oldWidth, width);
        super.setBounds(x, y, width, height);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.parentPanel != null) {
            SelectionPainter.paintForBlockPanel(this, this.parentPanel, this.selection, g);
        }
    }
}

