/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.freeplane.core.ui.components.StyledIcon;
import org.freeplane.core.ui.components.TextIcon;

public class DoubleTextIcon
implements StyledIcon {
    private final TextIcon firstIcon;
    private final TextIcon secondIcon;
    private int paddingX;
    private int paddingY;
    private Color iconBackgroundColor;
    private Color underlineColor;
    private BasicStroke underlineStroke;
    private UnderlinePosition underlinePosition = UnderlinePosition.NONE;

    public DoubleTextIcon(String leftText, String rightText, FontMetrics fontMetrics) {
        this.firstIcon = new TextIcon(leftText, fontMetrics);
        this.secondIcon = new TextIcon(rightText, fontMetrics);
        this.firstIcon.setPaddingX(0);
        this.secondIcon.setPaddingX(0);
        this.firstIcon.setPaddingY(0);
        this.secondIcon.setPaddingY(0);
        this.firstIcon.setBorderType(TextIcon.BorderType.UNDERLINE);
        this.secondIcon.setBorderType(TextIcon.BorderType.UNDERLINE);
        this.updateUnderlineState();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int x, int y) {
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        if (this.iconBackgroundColor != null) {
            Color originalColor = graphics.getColor();
            graphics.setColor(this.iconBackgroundColor);
            graphics.fillRect(x, y, iconWidth, iconHeight);
            graphics.setColor(originalColor);
        }
        int contentX = x + this.paddingX;
        int contentY = y + this.paddingY;
        ComponentOrientation orientation = component != null ? component.getComponentOrientation() : null;
        boolean paintRightToLeft = orientation != null && orientation.isHorizontal() && !orientation.isLeftToRight();
        TextIcon leftIcon = paintRightToLeft ? this.secondIcon : this.firstIcon;
        TextIcon rightIcon = paintRightToLeft ? this.firstIcon : this.secondIcon;
        leftIcon.paintIcon(component, graphics, contentX, contentY);
        int rightIconX = contentX + leftIcon.getIconWidth();
        rightIcon.paintIcon(component, graphics, rightIconX, contentY);
    }

    @Override
    public int getIconWidth() {
        return this.paddingX * 2 + this.firstIcon.getIconWidth() + this.secondIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        int baseHeight = Math.max(this.firstIcon.getIconHeight(), this.secondIcon.getIconHeight());
        return this.paddingY * 2 + baseHeight;
    }

    @Override
    public Color getIconTextColor() {
        return this.firstIcon.getIconTextColor();
    }

    @Override
    public DoubleTextIcon setIconTextColor(Color iconTextColor) {
        this.firstIcon.setIconTextColor(iconTextColor);
        this.secondIcon.setIconTextColor(iconTextColor);
        return this;
    }

    @Override
    public Color getIconBackgroundColor() {
        return this.iconBackgroundColor;
    }

    @Override
    public DoubleTextIcon setIconBackgroundColor(Color iconBackgroundColor) {
        this.iconBackgroundColor = iconBackgroundColor;
        if (iconBackgroundColor != null) {
            this.firstIcon.setIconBackgroundColor(iconBackgroundColor);
            this.secondIcon.setIconBackgroundColor(iconBackgroundColor);
        }
        this.firstIcon.setIconBackgroundColor(null);
        this.secondIcon.setIconBackgroundColor(null);
        return this;
    }

    @Override
    public Color getIconBorderColor() {
        return this.underlineColor;
    }

    @Override
    public DoubleTextIcon setIconBorderColor(Color iconBorderColor) {
        this.underlineColor = iconBorderColor;
        if (iconBorderColor != null && this.underlineStroke == null) {
            this.underlineStroke = TextIcon.DEFAULT_STROKE;
        }
        this.updateUnderlineState();
        return this;
    }

    public TextIcon.BorderType getBorderType() {
        return TextIcon.BorderType.UNDERLINE;
    }

    @Override
    public BasicStroke getBorderStroke() {
        return this.underlineStroke;
    }

    @Override
    public DoubleTextIcon setBorderStroke(BasicStroke borderStroke) {
        this.underlineStroke = borderStroke;
        this.updateUnderlineState();
        return this;
    }

    @Override
    public int getPaddingX() {
        return this.paddingX;
    }

    @Override
    public void setPaddingX(int paddingX) {
        this.paddingX = paddingX;
    }

    @Override
    public int getPaddingY() {
        return this.paddingY;
    }

    @Override
    public void setPaddingY(int paddingY) {
        this.paddingY = paddingY;
    }

    @Override
    public void setPadding(int padding) {
        this.paddingX = padding;
        this.paddingY = padding;
    }

    public UnderlinePosition getUnderlinePosition() {
        return this.underlinePosition;
    }

    public DoubleTextIcon setUnderlinePosition(UnderlinePosition underlinePosition) {
        this.underlinePosition = underlinePosition;
        this.updateUnderlineState();
        return this;
    }

    public String getFirstText() {
        return this.firstIcon.getText();
    }

    public String getSecondText() {
        return this.secondIcon.getText();
    }

    public int getRightIconX(Component component) {
        ComponentOrientation orientation = component != null ? component.getComponentOrientation() : null;
        boolean paintRightToLeft = orientation != null && orientation.isHorizontal() && !orientation.isLeftToRight();
        int leftIconWidth = paintRightToLeft ? this.secondIcon.getIconWidth() : this.firstIcon.getIconWidth();
        return this.paddingX + leftIconWidth;
    }

    private void updateUnderlineState() {
        this.firstIcon.setIconBorderColor(this.underlineColor);
        this.secondIcon.setIconBorderColor(this.underlineColor);
        this.firstIcon.setBorderStroke(this.shouldPaintUnderlineFirst() ? this.underlineStroke : null);
        this.secondIcon.setBorderStroke(this.shouldPaintUnderlineSecond() ? this.underlineStroke : null);
    }

    private boolean shouldPaintUnderlineFirst() {
        return this.underlinePosition == UnderlinePosition.LEFT || this.underlinePosition == UnderlinePosition.BOTH;
    }

    private boolean shouldPaintUnderlineSecond() {
        return this.underlinePosition == UnderlinePosition.RIGHT || this.underlinePosition == UnderlinePosition.BOTH;
    }

    public static enum UnderlinePosition {
        NONE,
        LEFT,
        RIGHT,
        BOTH;

    }
}

