import { TextDocument } from "vscode-languageserver-textdocument";
import { WorkspaceManager } from "../src/services/workspaceManager";
import { CompletionItem } from "vscode-languageserver/node";
import { ValidationManager } from "../src/services/validationManager";
import { ExtensionSettings } from "../src/interfaces/extensionSettings";
export declare const FIXTURES_BASE_PATH: string;
export declare const ANSIBLE_COLLECTIONS_FIXTURES_BASE_PATH: string;
export declare const ANSIBLE_ADJACENT_COLLECTIONS__PATH: string;
export declare const ANSIBLE_CONFIG_FILE: string;
export declare function setFixtureAnsibleCollectionPathEnv(prePendPath?: string): void;
export declare function unSetFixtureAnsibleCollectionPathEnv(): void;
export declare function setAnsibleConfigEnv(): void;
export declare function unsetAnsibleConfigEnv(): void;
export declare function enableExecutionEnvironmentSettings(docSettings: Thenable<ExtensionSettings>): Promise<void>;
export declare function disableExecutionEnvironmentSettings(docSettings: Thenable<ExtensionSettings>): Promise<void>;
export declare function resolveDocUri(filename: string): string;
export declare function getDoc(filename: string): TextDocument;
export declare function isWindows(): boolean;
/**
 * A function that tries to imitate the filtering of the completion items done in the respective client extension
 * when the user starts typing against the provided auto-completions
 * @param completionList - list with completion items
 * @param triggerCharacter - string against which fuzzy search is to be done
 * @returns list after sorting and filtering
 */
export declare function smartFilter(completionList: CompletionItem[], triggerCharacter: string): CompletionItem[];
/**
 * A function that initiates the connection object with ipc that can be used to create a workspace manager for testing purposes
 * @returns WorkspaceManager - object to serve as a workspace manager for testing purposes
 */
export declare function createTestWorkspaceManager(): WorkspaceManager;
export declare function createTestValidationManager(): ValidationManager;
