/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.cpu;

import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import org.graalvm.visualvm.lib.jfluid.filters.InstrumentationFilter;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.cpu.FlatProfileProvider;
import org.graalvm.visualvm.lib.jfluid.results.cpu.MethodInfoMapper;
import org.graalvm.visualvm.lib.jfluid.results.cpu.StackTraceSnapshotBuilder;
import org.graalvm.visualvm.lib.jfluid.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.graalvm.visualvm.lib.ui.cpu.CPUResUserActionsHandler;
import org.graalvm.visualvm.lib.ui.cpu.LiveFlatProfileCollectorPanel;
import org.graalvm.visualvm.sampler.cpu.CCTFlattener;
import org.graalvm.visualvm.sampler.cpu.FlatProfileBuilder;

final class SampledLivePanel
extends LiveFlatProfileCollectorPanel {
    private MethodInfoMapper methodInfoMapper;
    private StackTraceSnapshotBuilder snapshotBuilder;

    SampledLivePanel(StackTraceSnapshotBuilder builder) {
        super(null, (CPUResUserActionsHandler)new DummyHandler(), null, true);
        this.methodInfoMapper = builder.getMapper();
        this.snapshotBuilder = builder;
    }

    public FlatProfileProvider getFlatProfileProvider() {
        InstrumentationFilter filter = this.snapshotBuilder.getFilter();
        boolean twoTimeStamps = this.snapshotBuilder.collectionTwoTimeStamps();
        CCTFlattener flattener = new CCTFlattener(twoTimeStamps, this.methodInfoMapper, filter);
        RuntimeCPUCCTNode rootNode = (RuntimeCPUCCTNode)this.snapshotBuilder.getAppRootNode();
        return new FlatProfileBuilder(rootNode, flattener);
    }

    protected String[] getMethodClassNameAndSig(int methodId, int currentView) {
        String className = this.methodInfoMapper.getInstrMethodClass(methodId);
        if (currentView == 0) {
            String methodName = this.methodInfoMapper.getInstrMethodName(methodId);
            String methodSig = this.methodInfoMapper.getInstrMethodSignature(methodId);
            return new String[]{className, methodName, methodSig};
        }
        return new String[]{className, null, null};
    }

    protected void obtainResults() {
        super.obtainResults();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SampledLivePanel.this.resTable.createDefaultColumnsFromModel();
                SampledLivePanel.this.resTableModel.setTable((JTable)SampledLivePanel.this.resTable);
                SampledLivePanel.this.setColumnsData();
            }
        });
    }

    private void setColumnsData() {
        TableColumnModel colModel = this.resTable.getColumnModel();
        for (int i = 0; i < this.resTableModel.getColumnCount(); ++i) {
            int index = this.resTableModel.getRealColumn(i);
            if (index != 0) {
                colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            }
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private static final class DummyHandler
    extends CPUResUserActionsHandler.Adapter {
        private DummyHandler() {
        }

        public void addMethodToRoots(String className, String methodName, String methodSig) {
            throw new IllegalStateException("addMethodToRoots");
        }

        public void showReverseCallGraph(CPUResultsSnapshot snapshot, int threadId, int methodId, int view, int sortingColumn, boolean sortingOrder) {
            throw new IllegalStateException("showReverseCallGraph");
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
        }

        public void viewChanged(int viewType) {
            throw new IllegalStateException("viewChanged");
        }
    }
}

