/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.util.LightWeightHashSet;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;

class ExcessRedundancyMap {
    public static final Logger blockLog = NameNode.blockStateChangeLog;
    private final Map<String, LightWeightHashSet<Block>> map = new HashMap<String, LightWeightHashSet<Block>>();
    private final AtomicLong size = new AtomicLong(0L);

    ExcessRedundancyMap() {
    }

    long size() {
        return this.size.get();
    }

    @VisibleForTesting
    synchronized int getSize4Testing(String dnUuid) {
        LightWeightHashSet<Block> set = this.map.get(dnUuid);
        return set == null ? 0 : set.size();
    }

    synchronized void clear() {
        this.map.clear();
        this.size.set(0L);
    }

    synchronized boolean contains(DatanodeDescriptor dn, BlockInfo blk) {
        LightWeightHashSet<Block> set = this.map.get(dn.getDatanodeUuid());
        return set != null && set.contains((Object)blk);
    }

    synchronized boolean add(DatanodeDescriptor dn, BlockInfo blk) {
        boolean added;
        LightWeightHashSet<Object> set = this.map.get(dn.getDatanodeUuid());
        if (set == null) {
            set = new LightWeightHashSet();
            this.map.put(dn.getDatanodeUuid(), set);
        }
        if (added = set.add((Object)new ExcessBlockInfo(blk))) {
            this.size.incrementAndGet();
            blockLog.debug("BLOCK* ExcessRedundancyMap.add({}, {})", (Object)dn, (Object)blk);
        }
        return added;
    }

    synchronized boolean remove(DatanodeDescriptor dn, BlockInfo blk) {
        LightWeightHashSet<Block> set = this.map.get(dn.getDatanodeUuid());
        if (set == null) {
            return false;
        }
        boolean removed = set.remove((Object)blk);
        if (removed) {
            this.size.decrementAndGet();
            blockLog.debug("BLOCK* ExcessRedundancyMap.remove({}, {})", (Object)dn, (Object)blk);
            if (set.isEmpty()) {
                this.map.remove(dn.getDatanodeUuid());
            }
        }
        return removed;
    }

    synchronized Map<String, LightWeightHashSet<Block>> getExcessRedundancyMap() {
        return this.map;
    }

    static class ExcessBlockInfo
    extends Block {
        private long timeStamp = Time.monotonicNow();
        private final BlockInfo blockInfo;

        ExcessBlockInfo(BlockInfo blockInfo) {
            super(blockInfo.getBlockId(), blockInfo.getNumBytes(), blockInfo.getGenerationStamp());
            this.blockInfo = blockInfo;
        }

        public BlockInfo getBlockInfo() {
            return this.blockInfo;
        }

        long getTimeStamp() {
            return this.timeStamp;
        }

        void setTimeStamp() {
            this.timeStamp = Time.monotonicNow();
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }
}

