/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.PriorityQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.lib.join.ComposableRecordReader;
import org.apache.hadoop.mapreduce.lib.join.MultiFilterRecordReader;
import org.apache.hadoop.mapreduce.lib.join.TupleWritable;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class OverrideRecordReader<K extends WritableComparable<?>, V extends Writable>
extends MultiFilterRecordReader<K, V> {
    private Class<? extends Writable> valueclass = null;

    OverrideRecordReader(int id, Configuration conf, int capacity, Class<? extends WritableComparator> cmpcl) throws IOException {
        super(id, conf, capacity, cmpcl);
    }

    @Override
    protected V emit(TupleWritable dst) {
        return (V)dst.iterator().next();
    }

    @Override
    public V createValue() {
        if (null == this.valueclass) {
            Class<?> cls = this.kids[this.kids.length - 1].createValue().getClass();
            int i = this.kids.length - 1;
            while (cls.equals(NullWritable.class)) {
                cls = this.kids[i].createValue().getClass();
                --i;
            }
            this.valueclass = cls.asSubclass(Writable.class);
        }
        if (this.valueclass.equals(NullWritable.class)) {
            return (V)NullWritable.get();
        }
        return (V)ReflectionUtils.newInstance(this.valueclass, null);
    }

    @Override
    protected void fillJoinCollector(K iterkey) throws IOException, InterruptedException {
        PriorityQueue q = this.getRecordReaderQueue();
        if (q != null && !q.isEmpty()) {
            ComposableRecordReader t;
            int highpos = -1;
            ArrayList<ComposableRecordReader> list = new ArrayList<ComposableRecordReader>(this.kids.length);
            q.peek().key(iterkey);
            WritableComparator cmp = this.getComparator();
            while (0 == cmp.compare((WritableComparable)q.peek().key(), (WritableComparable)iterkey)) {
                t = q.poll();
                if (-1 == highpos || ((ComposableRecordReader)list.get(highpos)).id() < t.id()) {
                    highpos = list.size();
                }
                list.add(t);
                if (!q.isEmpty()) continue;
                break;
            }
            t = (ComposableRecordReader)list.remove(highpos);
            t.accept(this.jc, iterkey);
            for (ComposableRecordReader rr : list) {
                rr.skip(iterkey);
            }
            list.add(t);
            for (ComposableRecordReader rr : list) {
                if (!rr.hasNext()) continue;
                q.add(rr);
            }
        }
    }
}

