/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.util.Map;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;
import org.opensearch.ingest.ValueSource;
import org.opensearch.script.ScriptService;
import org.opensearch.script.TemplateScript;

public final class AppendProcessor
extends AbstractProcessor {
    public static final String TYPE = "append";
    private final TemplateScript.Factory field;
    private final ValueSource value;
    private final boolean allowDuplicates;

    AppendProcessor(String tag, String description, TemplateScript.Factory field, ValueSource value, boolean allowDuplicates) {
        super(tag, description);
        this.field = field;
        this.value = value;
        this.allowDuplicates = allowDuplicates;
    }

    public TemplateScript.Factory getField() {
        return this.field;
    }

    public ValueSource getValue() {
        return this.value;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        ingestDocument.appendFieldValue(this.field, this.value, this.allowDuplicates);
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public AppendProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)AppendProcessor.TYPE, (String)processorTag, config, (String)"field");
            Object value = ConfigurationUtils.readObject((String)AppendProcessor.TYPE, (String)processorTag, config, (String)"value");
            boolean allowDuplicates = ConfigurationUtils.readBooleanProperty((String)AppendProcessor.TYPE, (String)processorTag, config, (String)"allow_duplicates", (boolean)true);
            TemplateScript.Factory compiledTemplate = ConfigurationUtils.compileTemplate((String)AppendProcessor.TYPE, (String)processorTag, (String)"field", (String)field, (ScriptService)this.scriptService);
            return new AppendProcessor(processorTag, description, compiledTemplate, ValueSource.wrap((Object)value, (ScriptService)this.scriptService), allowDuplicates);
        }
    }
}

