/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.SimpleScrollPane;
import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PopupMenuUI;

public class JidePopupMenu
extends JPopupMenu
implements Scrollable {
    private static final String uiClassID = "JidePopupMenuUI";
    private static final String uiClassIDAlternative = "PopupMenuUI";
    private boolean _useLightWeightPopup;
    private int _visibleMenuItemCount;

    public JidePopupMenu() {
        this.setupPopupMenu();
    }

    public JidePopupMenu(String label) {
        super(label);
        this.setupPopupMenu();
    }

    @Override
    public String getUIClassID() {
        return UIDefaultsLookup.getBoolean("JidePopupMenu.uiExtensionDisabled") ? uiClassIDAlternative : uiClassID;
    }

    private void setupPopupMenu() {
        this.addPopupMenuListener(new ToolTipSwitchPopupMenuListener());
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(this.getUIClassID()) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((PopupMenuUI)UIManager.getUI(this));
    }

    @Override
    public void show(Component invoker, int x, int y) {
        Point p = this.getPopupMenuOrigin(invoker, x, y);
        super.show(invoker, p.x, p.y);
    }

    protected Point getPopupMenuOrigin(Component invoker, int x, int y) {
        Dimension size = this.getPreferredScrollableViewportSize();
        Point p = new Point(x, y);
        SwingUtilities.convertPointToScreen(p, invoker);
        Rectangle bounds = PortingUtils.ensureOnScreen(new Rectangle(p, size));
        p = bounds.getLocation();
        SwingUtilities.convertPointFromScreen(p, invoker);
        return p;
    }

    @Override
    public void setLocation(int x, int y) {
        if (this.isVisible() && y <= 0) {
            this.move(x, y);
        } else {
            super.setLocation(x, y);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = this.getPreferredSize();
        Dimension screenSize = PortingUtils.getLocalScreenSize(this);
        Container container = SwingUtilities.getAncestorOfClass(SimpleScrollPane.class, this);
        if (container instanceof SimpleScrollPane) {
            int totalHeight;
            SimpleScrollPane scrollPane = (SimpleScrollPane)container;
            int height = screenSize.height;
            if (this.getVisibleMenuItemCount() > 0 && height > (totalHeight = this.getVisibleMenuItemCount() * this.getScrollableUnitIncrement(null, 0, 0))) {
                height = totalHeight;
            }
            size.height = Math.min(size.height, height - scrollPane.getScrollUpButton().getPreferredSize().height - scrollPane.getScrollDownButton().getPreferredSize().height);
        }
        return size;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return new JMenuItem((String)"ABC").getPreferredSize().height;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return new JMenuItem((String)"ABC").getPreferredSize().height * 5;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public int getVisibleMenuItemCount() {
        return this._visibleMenuItemCount;
    }

    public void setVisibleMenuItemCount(int visibleMenuItemCount) {
        if (this._visibleMenuItemCount != visibleMenuItemCount) {
            int oldValue = this._visibleMenuItemCount;
            this._visibleMenuItemCount = visibleMenuItemCount;
            this.firePropertyChange("visibleMenuCount", oldValue, visibleMenuItemCount);
        }
    }

    private class ToolTipSwitchPopupMenuListener
    implements PopupMenuListener {
        private ToolTipSwitchPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JidePopupMenu.this._useLightWeightPopup = ToolTipManager.sharedInstance().isLightWeightPopupEnabled();
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(JidePopupMenu.this._useLightWeightPopup);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(JidePopupMenu.this._useLightWeightPopup);
        }
    }
}

