/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.openstreetmap.josm.tools.Logging;

public class InvalidXmlCharacterFilter
extends Reader {
    private final Reader reader;
    private static boolean firstWarning = true;
    private static final boolean[] INVALID_CHARS = new boolean[32];

    public InvalidXmlCharacterFilter(Reader reader) {
        this.reader = reader;
    }

    @Override
    public int read(char[] b, int off, int len) throws IOException {
        int n = this.reader.read(b, off, len);
        if (n == -1) {
            return -1;
        }
        for (int i = off; i < off + n; ++i) {
            b[i] = InvalidXmlCharacterFilter.filter(b[i]);
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private static char filter(char in) {
        if (in < ' ' && INVALID_CHARS[in]) {
            if (firstWarning) {
                Logging.warn("Invalid xml character encountered: '" + in + "'.");
                firstWarning = false;
            }
            return ' ';
        }
        return in;
    }

    static {
        Arrays.fill(INVALID_CHARS, true);
        InvalidXmlCharacterFilter.INVALID_CHARS[9] = false;
        InvalidXmlCharacterFilter.INVALID_CHARS[10] = false;
        InvalidXmlCharacterFilter.INVALID_CHARS[13] = false;
    }
}

