/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.test;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.NullOutputStream;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import junit.framework.TestCase;

public class MetadataTest
extends TestCase {
    public MetadataTest(String s) {
        super(s);
    }

    public void testSetAndGetSingleTag() throws Exception {
        Metadata metadata = new Metadata();
        Directory directory = metadata.getDirectory(ExifDirectory.class);
        directory.setInt(37378, 1);
        MetadataTest.assertEquals((int)1, (int)directory.getInt(37378));
    }

    public void testSetSameTagMultpleTimes() throws Exception {
        Metadata metadata = new Metadata();
        Directory directory = metadata.getDirectory(ExifDirectory.class);
        directory.setInt(37378, 1);
        directory.setInt(37378, 2);
        MetadataTest.assertEquals((String)"setting the tag with a different value should override old value", (int)2, (int)directory.getInt(37378));
    }

    public void testGetDirectory() throws Exception {
        Metadata metadata = new Metadata();
        MetadataTest.assertTrue((boolean)(metadata.getDirectory(ExifDirectory.class) instanceof ExifDirectory));
    }

    public void testSetAndGetMultipleTagsInSingleDirectory() throws Exception {
        Metadata metadata = new Metadata();
        Directory exifDir = metadata.getDirectory(ExifDirectory.class);
        exifDir.setString(37378, "Tag Value");
        exifDir.setString(33423, "Another tag");
        MetadataTest.assertEquals((String)"Tag Value", (String)exifDir.getString(37378));
        MetadataTest.assertEquals((String)"Another tag", (String)exifDir.getString(33423));
    }

    public void testSetAndGetMultipleTagsInMultilpeDirectories() throws Exception {
        Metadata metadata = new Metadata();
        Directory exifDir = metadata.getDirectory(ExifDirectory.class);
        Directory gpsDir = metadata.getDirectory(GpsDirectory.class);
        exifDir.setString(37378, "ExifAperture");
        exifDir.setString(33423, "ExifBatteryLevel");
        gpsDir.setString(6, "GpsAltitude");
        gpsDir.setString(24, "GpsDestBearing");
        MetadataTest.assertEquals((String)"ExifAperture", (String)exifDir.getString(37378));
        MetadataTest.assertEquals((String)"ExifBatteryLevel", (String)exifDir.getString(33423));
        MetadataTest.assertEquals((String)"GpsAltitude", (String)gpsDir.getString(6));
        MetadataTest.assertEquals((String)"GpsDestBearing", (String)gpsDir.getString(24));
    }

    public void testContainsTag() throws Exception {
        Metadata metadata = new Metadata();
        Directory exifDir = metadata.getDirectory(ExifDirectory.class);
        MetadataTest.assertTrue((!exifDir.containsTag(37378) ? 1 : 0) != 0);
        exifDir.setString(37378, "Tag Value");
        MetadataTest.assertTrue((boolean)exifDir.containsTag(37378));
    }

    public void testGetNonExistantTag() throws Exception {
        Metadata metadata = new Metadata();
        Directory exifDir = metadata.getDirectory(ExifDirectory.class);
        MetadataTest.assertEquals(null, (String)exifDir.getString(37378));
    }

    public void testHasErrors() throws Exception {
        Metadata metadata = JpegMetadataReader.readMetadata(new File("src/com/drew/metadata/exif/test/badExif.jpg"));
        MetadataTest.assertTrue((String)"exif error", (boolean)metadata.getDirectory(ExifDirectory.class).hasErrors());
        metadata = JpegMetadataReader.readMetadata(new File("src/com/drew/metadata/exif/test/withExif.jpg"));
        MetadataTest.assertTrue((String)"no errors", (!metadata.getDirectory(ExifDirectory.class).hasErrors() ? 1 : 0) != 0);
    }

    public void testGetErrors() throws Exception {
        Metadata metadata = JpegMetadataReader.readMetadata(new File("src/com/drew/metadata/exif/test/badExif.jpg"));
        Iterator errors = metadata.getDirectory(ExifDirectory.class).getErrors();
        MetadataTest.assertTrue((boolean)errors.hasNext());
        String error = (String)errors.next();
        MetadataTest.assertEquals((String)"Exif data segment must contain at least 14 bytes", (String)error);
        MetadataTest.assertTrue((!errors.hasNext() ? 1 : 0) != 0);
    }

    public void testGetErrorCount() throws Exception {
        Metadata metadata = JpegMetadataReader.readMetadata(new File("src/com/drew/metadata/exif/test/badExif.jpg"));
        MetadataTest.assertEquals((int)1, (int)metadata.getDirectory(ExifDirectory.class).getErrorCount());
    }

    public void testMetadataSerializable() throws Exception {
        Metadata metadata = JpegMetadataReader.readMetadata(new File("src/com/drew/metadata/test/withIptcExifGps.jpg"));
        new ObjectOutputStream(new NullOutputStream()).writeObject(metadata);
    }

    public void testSerializeAndRestore() throws Exception {
        Metadata metadataWrite = JpegMetadataReader.readMetadata(new File("src/com/drew/metadata/test/withIptcExifGps.jpg"));
        File ser = File.createTempFile("test", "ser");
        try {
            new ObjectOutputStream(new FileOutputStream(ser)).writeObject(metadataWrite);
            Metadata metadataRead = (Metadata)new ObjectInputStream(new FileInputStream(ser)).readObject();
            MetadataTest.assertTrue((boolean)metadataRead.containsDirectory(ExifDirectory.class));
            MetadataTest.assertTrue((boolean)metadataRead.containsDirectory(IptcDirectory.class));
        }
        finally {
            ser.delete();
        }
    }
}

