/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.Locator;
import io.sf.carte.doc.style.css.nsac.ParserControl;
import io.sf.carte.doc.style.css.parser.BufferTokenHandler;
import io.sf.carte.doc.style.css.parser.CSSContentHandler;
import io.sf.carte.doc.style.css.parser.CSSTokenHandler;
import io.sf.carte.doc.style.css.parser.LocatorImpl;
import io.sf.carte.uparser.ContentHandler;
import io.sf.carte.uparser.ControlHandler;
import io.sf.carte.uparser.TokenControl;
import io.sf.carte.uparser.TokenErrorHandler;

abstract class ControlTokenHandler
implements ParserControl,
ControlHandler<RuntimeException> {
    private int line;
    private int prevlinelength;
    private boolean foundCp13andNotYet10or12 = false;
    private transient int column;
    private TokenControl parserctl = null;

    ControlTokenHandler() {
        this.line = 1;
        this.prevlinelength = -1;
    }

    ControlTokenHandler(ControlTokenHandler copyMe) {
        this.line = copyMe.getCurrentLine();
        this.prevlinelength = copyMe.getPrevLineLength();
        this.foundCp13andNotYet10or12 = copyMe.foundCp13andNotYet10or12;
        this.parserctl = copyMe.parserctl;
    }

    @Override
    public Locator createLocator() {
        return new LocatorImpl(this.line, this.column);
    }

    public int getCurrentLine() {
        return this.line;
    }

    public int getPrevLineLength() {
        return this.prevlinelength;
    }

    void setCurrentLocation(int index) {
        this.column = index - this.prevlinelength;
    }

    public CSSParseException createException(int index, byte errCode, String message) {
        this.setCurrentLocation(index);
        Locator locator = this.createLocator();
        if (errCode == 15) {
            return new CSSNamespaceParseException(message, locator);
        }
        return new CSSParseException(message, locator);
    }

    public void quotedNewlineChar(int index, int codepoint) {
        if (codepoint == 10) {
            if (!this.getCurrentHandler().isPreviousCp(13)) {
                ++this.line;
                this.prevlinelength = index;
            }
        } else if (codepoint == 12) {
            ++this.line;
            this.prevlinelength = index;
        } else if (codepoint == 13) {
            ++this.line;
            this.prevlinelength = index;
            this.getCurrentHandler().setHandlerPreviousCp(codepoint);
        }
    }

    public void control(int index, int codepoint) {
        CSSTokenHandler curHandler = this.getCurrentHandler();
        if (codepoint == 10) {
            curHandler.separator(index, 10);
            if (!this.foundCp13andNotYet10or12) {
                ++this.line;
                this.prevlinelength = index;
            } else {
                this.foundCp13andNotYet10or12 = false;
                ++this.prevlinelength;
            }
            curHandler.setHandlerPreviousCp(10);
        } else if (codepoint == 12) {
            curHandler.separator(index, 10);
            curHandler.setHandlerPreviousCp(10);
            if (!this.foundCp13andNotYet10or12) {
                ++this.line;
            } else {
                this.foundCp13andNotYet10or12 = false;
            }
            this.prevlinelength = index;
        } else if (codepoint == 13) {
            ++this.line;
            this.prevlinelength = index;
            this.foundCp13andNotYet10or12 = true;
        } else if (codepoint == 9) {
            curHandler.separator(index, 9);
        } else if (codepoint < 128) {
            curHandler.unexpectedCharError(index, codepoint);
        } else {
            this.highControl(index, codepoint);
        }
    }

    protected void highControl(int index, int codepoint) {
        CSSTokenHandler curHandler = this.getCurrentHandler();
        if (!curHandler.isInError()) {
            curHandler.handleError(index, (byte)4, "Unexpected control: " + codepoint);
        }
    }

    public void tokenStart(TokenControl control) {
        this.setTokenControl(control);
    }

    public void setTokenControl(TokenControl parserctl) {
        this.parserctl = parserctl;
    }

    public TokenControl getTokenControl() {
        return this.parserctl;
    }

    public CSSTokenHandler getCurrentHandler() {
        return (CSSTokenHandler)this.parserctl.getContentHandler();
    }

    public void yieldHandling(CSSContentHandler yieldHandler) {
        TokenControl ctl = this.getTokenControl();
        ctl.setContentHandler((ContentHandler)yieldHandler);
        ctl.setErrorHandler((TokenErrorHandler)yieldHandler);
    }

    boolean isInErrorRecovery() {
        return this.getCurrentHandler() instanceof BufferTokenHandler.IgnoredDeclarationTokenHandler;
    }
}

