!
! Copyright Intel Corporation.
! 
! This software and the related documents are Intel copyrighted materials, and
! your use of them is governed by the express license under which they were
! provided to you (License). Unless the License provides otherwise, you may
! not use, modify, copy, publish, distribute, disclose or transmit this
! software or the related documents without Intel's prior written permission.
! 
! This software and the related documents are provided as is, with no express
! or implied warranties, other than those that are expressly stated in the
! License.
! Copyright (C) by Argonne National Laboratory
! 
! 				  COPYRIGHT
! 
! The following is a notice of limited availability of the code, and disclaimer
! which must be included in the prologue of the code and in all source listings
! of the code.
! 
! Copyright Notice
! 1998--2020, Argonne National Laboratory
! 
! Permission is hereby granted to use, reproduce, prepare derivative works, and
! to redistribute to others.  This software was authored by:
! 
! Mathematics and Computer Science Division
! Argonne National Laboratory, Argonne IL 60439
! 
! (and)
! 
! Department of Computer Science
! University of Illinois at Urbana-Champaign
! 
! 
! 			      GOVERNMENT LICENSE
! 
! Portions of this material resulted from work developed under a U.S.
! Government Contract and are subject to the following license: the Government
! is granted for itself and others acting on its behalf a paid-up, nonexclusive,
! irrevocable worldwide license in this computer software to reproduce, prepare
! derivative works, and perform publicly and display publicly.
! 
! 				  DISCLAIMER
! 
! This computer code material was prepared, in part, as an account of work
! sponsored by an agency of the United States Government.  Neither the United
! States, nor the University of Chicago, nor any of their employees, makes any
! warranty express or implied, or assumes any legal liability or responsibility
! for the accuracy, completeness, or usefulness of any information, apparatus,
! product, or process disclosed, or represents that its use would not infringe
! privately owned rights.
! 
! 			   EXTERNAL CONTRIBUTIONS
! 
! Portions of this code have been contributed under the above license by:
! 
!  * Intel Corporation
!  * Cray
!  * IBM Corporation
!  * Microsoft Corporation
!  * Mellanox Technologies Ltd.
!  * DataDirect Networks.
!  * Oak Ridge National Laboratory
!  * Sun Microsystems, Lustre group
!  * Dolphin Interconnect Solutions Inc.
!  * Institut Polytechnique de Bordeaux
!
!     
        MODULE MPI_CONSTANTS
        IMPLICIT NONE
        INCLUDE 'mpifnoext.h'
        TYPE :: MPI_Status
           SEQUENCE
           INTEGER :: MPI_SOURCE, MPI_TAG, MPI_ERROR
           INTEGER :: count_lo
           INTEGER :: count_hi_and_cancelled
        END TYPE MPI_Status
       TYPE :: MPI_Info
          SEQUENCE
          INTEGER :: MPI_VAL
       END TYPE MPI_Info
       TYPE :: MPI_Request
          SEQUENCE
          INTEGER :: MPI_VAL
       END TYPE MPI_Request
       TYPE :: MPI_Comm
          SEQUENCE
          INTEGER :: MPI_VAL
       END TYPE MPI_Comm
       TYPE :: MPI_Win
          SEQUENCE
          INTEGER :: MPI_VAL
       END TYPE MPI_Win
       TYPE :: MPI_File
          SEQUENCE
          INTEGER :: MPI_VAL
       END TYPE MPI_File
       TYPE :: MPI_Message
          SEQUENCE
          INTEGER :: MPI_VAL
       END TYPE MPI_Message
       TYPE :: MPI_Errhandler
          SEQUENCE
          INTEGER :: MPI_VAL
       END TYPE MPI_Errhandler
       TYPE :: MPI_Group
          SEQUENCE
          INTEGER :: MPI_VAL
       END TYPE MPI_Group
       TYPE :: MPI_Session
          SEQUENCE
          INTEGER :: MPI_VAL
       END TYPE MPI_Session
       TYPE :: MPI_Datatype
          SEQUENCE
          INTEGER :: MPI_VAL
       END TYPE MPI_Datatype
       TYPE :: MPI_Op
          SEQUENCE
          INTEGER :: MPI_VAL
       END TYPE MPI_Op
        INTERFACE OPERATOR(.EQ.)
            MODULE PROCEDURE infoeq
            MODULE PROCEDURE requesteq
            MODULE PROCEDURE commeq
            MODULE PROCEDURE wineq
            MODULE PROCEDURE fileeq
            MODULE PROCEDURE messageeq
            MODULE PROCEDURE errhandlereq
            MODULE PROCEDURE groupeq
            MODULE PROCEDURE sessioneq
            MODULE PROCEDURE datatypeeq
            MODULE PROCEDURE opeq
        END INTERFACE
        INTERFACE OPERATOR(.NE.)
            MODULE PROCEDURE infoneq
            MODULE PROCEDURE requestneq
            MODULE PROCEDURE commneq
            MODULE PROCEDURE winneq
            MODULE PROCEDURE fileneq
            MODULE PROCEDURE messageneq
            MODULE PROCEDURE errhandlerneq
            MODULE PROCEDURE groupneq
            MODULE PROCEDURE sessionneq
            MODULE PROCEDURE datatypeneq
            MODULE PROCEDURE opneq
        END INTERFACE
        CONTAINS
            LOGICAL FUNCTION infoeq(lhs,rhs)
            TYPE(MPI_Info), INTENT(IN) :: lhs, rhs
            infoeq = lhs%MPI_VAL .EQ. rhs%MPI_VAL
            END FUNCTION infoeq
            LOGICAL FUNCTION infoneq(lhs,rhs)
            TYPE(MPI_Info), INTENT(IN) :: lhs, rhs
            infoneq = lhs%MPI_VAL .NE. rhs%MPI_VAL
            END FUNCTION infoneq
            LOGICAL FUNCTION requesteq(lhs,rhs)
            TYPE(MPI_Request), INTENT(IN) :: lhs, rhs
            requesteq = lhs%MPI_VAL .EQ. rhs%MPI_VAL
            END FUNCTION requesteq
            LOGICAL FUNCTION requestneq(lhs,rhs)
            TYPE(MPI_Request), INTENT(IN) :: lhs, rhs
            requestneq = lhs%MPI_VAL .NE. rhs%MPI_VAL
            END FUNCTION requestneq
            LOGICAL FUNCTION commeq(lhs,rhs)
            TYPE(MPI_Comm), INTENT(IN) :: lhs, rhs
            commeq = lhs%MPI_VAL .EQ. rhs%MPI_VAL
            END FUNCTION commeq
            LOGICAL FUNCTION commneq(lhs,rhs)
            TYPE(MPI_Comm), INTENT(IN) :: lhs, rhs
            commneq = lhs%MPI_VAL .NE. rhs%MPI_VAL
            END FUNCTION commneq
            LOGICAL FUNCTION wineq(lhs,rhs)
            TYPE(MPI_Win), INTENT(IN) :: lhs, rhs
            wineq = lhs%MPI_VAL .EQ. rhs%MPI_VAL
            END FUNCTION wineq
            LOGICAL FUNCTION winneq(lhs,rhs)
            TYPE(MPI_Win), INTENT(IN) :: lhs, rhs
            winneq = lhs%MPI_VAL .NE. rhs%MPI_VAL
            END FUNCTION winneq
            LOGICAL FUNCTION fileeq(lhs,rhs)
            TYPE(MPI_File), INTENT(IN) :: lhs, rhs
            fileeq = lhs%MPI_VAL .EQ. rhs%MPI_VAL
            END FUNCTION fileeq
            LOGICAL FUNCTION fileneq(lhs,rhs)
            TYPE(MPI_File), INTENT(IN) :: lhs, rhs
            fileneq = lhs%MPI_VAL .NE. rhs%MPI_VAL
            END FUNCTION fileneq
            LOGICAL FUNCTION messageeq(lhs,rhs)
            TYPE(MPI_Message), INTENT(IN) :: lhs, rhs
            messageeq = lhs%MPI_VAL .EQ. rhs%MPI_VAL
            END FUNCTION messageeq
            LOGICAL FUNCTION messageneq(lhs,rhs)
            TYPE(MPI_Message), INTENT(IN) :: lhs, rhs
            messageneq = lhs%MPI_VAL .NE. rhs%MPI_VAL
            END FUNCTION messageneq
            LOGICAL FUNCTION errhandlereq(lhs,rhs)
            TYPE(MPI_Errhandler), INTENT(IN) :: lhs, rhs
            errhandlereq = lhs%MPI_VAL .EQ. rhs%MPI_VAL
            END FUNCTION errhandlereq
            LOGICAL FUNCTION errhandlerneq(lhs,rhs)
            TYPE(MPI_Errhandler), INTENT(IN) :: lhs, rhs
            errhandlerneq = lhs%MPI_VAL .NE. rhs%MPI_VAL
            END FUNCTION errhandlerneq
            LOGICAL FUNCTION groupeq(lhs,rhs)
            TYPE(MPI_Group), INTENT(IN) :: lhs, rhs
            groupeq = lhs%MPI_VAL .EQ. rhs%MPI_VAL
            END FUNCTION groupeq
            LOGICAL FUNCTION groupneq(lhs,rhs)
            TYPE(MPI_Group), INTENT(IN) :: lhs, rhs
            groupneq = lhs%MPI_VAL .NE. rhs%MPI_VAL
            END FUNCTION groupneq
            LOGICAL FUNCTION sessioneq(lhs,rhs)
            TYPE(MPI_Session), INTENT(IN) :: lhs, rhs
            sessioneq = lhs%MPI_VAL .EQ. rhs%MPI_VAL
            END FUNCTION sessioneq
            LOGICAL FUNCTION sessionneq(lhs,rhs)
            TYPE(MPI_Session), INTENT(IN) :: lhs, rhs
            sessionneq = lhs%MPI_VAL .NE. rhs%MPI_VAL
            END FUNCTION sessionneq
            LOGICAL FUNCTION datatypeeq(lhs,rhs)
            TYPE(MPI_Datatype), INTENT(IN) :: lhs, rhs
            datatypeeq = lhs%MPI_VAL .EQ. rhs%MPI_VAL
            END FUNCTION datatypeeq
            LOGICAL FUNCTION datatypeneq(lhs,rhs)
            TYPE(MPI_Datatype), INTENT(IN) :: lhs, rhs
            datatypeneq = lhs%MPI_VAL .NE. rhs%MPI_VAL
            END FUNCTION datatypeneq
            LOGICAL FUNCTION opeq(lhs,rhs)
            TYPE(MPI_Op), INTENT(IN) :: lhs, rhs
            opeq = lhs%MPI_VAL .EQ. rhs%MPI_VAL
            END FUNCTION opeq
            LOGICAL FUNCTION opneq(lhs,rhs)
            TYPE(MPI_Op), INTENT(IN) :: lhs, rhs
            opneq = lhs%MPI_VAL .NE. rhs%MPI_VAL
            END FUNCTION opneq
        END MODULE MPI_CONSTANTS
