import sys
import os
import inspect
MAJOR,MINOR,_,_,_=sys.version_info
if sys.platform=="linux" or sys.platform=="linux2":
 SUPPORTED_VERSIONS=[(3,9)]
 LIB_SUFFIX=".so"
elif sys.platform=="win32":
 SUPPORTED_VERSIONS=[(3,9)]
 LIB_SUFFIX=".pyd"
else:
 print("The current platform ({}) is not supported. Please use Linux or Windows.".format(sys.platform))
 sys.exit(1)
if(MAJOR,MINOR)in SUPPORTED_VERSIONS:
 VERSIONED_MODULE_PATH="libs/py{}{}".format(MAJOR,MINOR)
 APM_ROOT=os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile(inspect.currentframe()))[0],'..')))
 APM_VERSIONED_ROOT=os.path.join(APM_ROOT,VERSIONED_MODULE_PATH)
 sys.path.append(APM_VERSIONED_ROOT)
else:
 print("Incompatible version of Python detected, please use one of the following versions.")
 print(["{}.{}".format(major,minor)for major,minor in SUPPORTED_VERSIONS])
 sys.exit(1)
from debug import myprint
from apm_helpers.messages import Messages as msg
if MAJOR==2:
 PYTHON_VERSION=2
 from future_builtins import filter
 filter=filter
 reduce=reduce
 input=raw_input
 maxsize=sys.maxint
 from time import clock
 process_time=clock
elif MAJOR==3:
 PYTHON_VERSION=3
 from functools import reduce
 filter=filter
 reduce=reduce
 input=input
 maxsize=sys.maxsize
 from time import process_time
 process_time=process_time
else:
 print(sys.version_info)
 myprint(msg.ERROR_UNEXPECTED_PYTHON_VERSION.format(sys.version_info),severity=4)
def python_ver_check():
 if MAJOR<3:
  myprint(msg.WARNING_PYTHON2_USED,severity=3)
 if MAJOR==3 and MINOR<6:
  myprint(msg.ERROR_PYTHON35_USED,severity=4)
def is_external_command(command):
 if MAJOR==3:
  from shutil import which
  return which(command)is not None
 else:
  from distutils.spawn import find_executable
  return find_executable(command)is not None
def open_utf8(name,mode):
 if MAJOR==3:
  return open(name,encoding='utf8',mode=mode)
 else:
  return open(name,mode)
