/*******************************************************************************
 * Copyright 2015 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *******************************************************************************/

/* Intel(R) Integrated Performance Primitives (Intel(R) IPP) */

#include "ippcore_tl.h"
#include "owndefs_tl.h"

#if defined(USE_OMP)
  #include <omp.h>

static int threads_of_ipp_tl = -1;

int IPP_CDECL ownGetNumThreads_LT(void)
{
    if (threads_of_ipp_tl < 1) {
        threads_of_ipp_tl = omp_get_max_threads();
    }
    return threads_of_ipp_tl;
}

int IPP_CDECL ownGetThreadIdx_LT(void) { return omp_get_thread_num(); }

IPPFUN(IppStatus, ippGetThreadingType_LT, (IppThreadingType * thrType))
{
    if (thrType == 0)
        return ippStsNullPtrErr;
    *thrType = OMP;
    return ippStsNoErr;
}

IPPFUN(IppStatus, ippGetThreadingType_T, (IppThreadingType * thrType)) { return ippGetThreadingType_LT(thrType); }

IPPFUN(IppStatus, ippGetNumThreads_LT, (int *pNumThr))
{
    if (pNumThr == 0)
        return ippStsNullPtrErr;
    *pNumThr = ownGetNumThreads_LT();
    return ippStsNoErr;
}
IPPFUN(IppStatus, ippGetNumThreads_T, (int *pNumThr)) { return ippGetNumThreads_LT(pNumThr); }

IPPFUN(IppStatus, ippSetNumThreads_LT, (int numThr))
{
    if (numThr <= 0)
        return ippStsSizeErr;
    omp_set_num_threads(numThr);
    threads_of_ipp_tl = numThr;
    return ippStsNoErr;
}
IPPFUN(IppStatus, ippSetNumThreads_T, (int numThr)) { return ippSetNumThreads_LT(numThr); }

IPPFUN(IppStatus, ippGetThreadIdx_LT, (int *pThrIdx))
{
    if (pThrIdx == 0)
        return ippStsNullPtrErr;
    *pThrIdx = ownGetThreadIdx_LT();
    return ippStsNoErr;
}
IPPFUN(IppStatus, ippGetThreadIdx_T, (int *pThrIdx)) { return ippGetThreadIdx_LT(pThrIdx); }

IPPFUN(IppStatus, ippParallelFor_LT, (IppSizeL numTiles, void *arg, functype_l func))
{
    if (arg == 0)
        return ippStsNullPtrErr;
    if (func == 0)
        return ippStsNullPtrErr;

    IppStatus status = ippStsNoErr;

  #pragma omp parallel
    {
        IppSizeL i = 0;
        IppStatus threadStatus = ippStsNoErr;

  #pragma omp for schedule(static, 1)
        for (i = 0; i < numTiles; ++i) {
            threadStatus = func(i, arg);
            if (threadStatus != ippStsNoErr)
                status = threadStatus; /* Save  Intel(R) IPP function status, if error is occurred */
        }
    }
    return status;
}

IPPFUN(IppStatus, ippParallelFor_T, (int numTiles, void *arg, functype func))
{
    if (arg == 0)
        return ippStsNullPtrErr;
    if (func == 0)
        return ippStsNullPtrErr;

    IppStatus status = ippStsNoErr;

  #pragma omp parallel
    {
        int i = 0;
        IppStatus threadStatus = ippStsNoErr;

  #pragma omp for schedule(static, 1)
        for (i = 0; i < numTiles; ++i) {
            threadStatus = func(i, arg);
            if (threadStatus != ippStsNoErr)
                status = threadStatus; /* Save  Intel(R) IPP function status, if error is occurred */
        }
    }
    return status;
}

#endif
