/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.Allocable;
import mpi.AllocablePool;
import mpi.Comm;
import mpi.Datatype;

public class Status
implements Allocable {
    private long handle;

    public Status() {
        this.init();
        AllocablePool.add(this);
    }

    public long getHandle() {
        return this.handle;
    }

    void setHandle(long l) {
        this.handle = l;
    }

    public int getCount(Datatype datatype) {
        return this.MPI_Get_Count(datatype.getId());
    }

    public Status probe(int n, int n2, Comm comm) {
        this.MPI_Probe(n, n2, comm.getHandle(), this.handle);
        return this;
    }

    public int getElements(Datatype datatype) {
        return this.MPI_Get_elements(datatype.getId());
    }

    @Override
    public void free() {
        AllocablePool.remove(this);
        this.free(this.handle);
    }

    private native void init();

    private native int MPI_Get_Count(int var1);

    private native int MPI_Probe(int var1, int var2, long var3, long var5);

    private native int MPI_Get_elements(int var1);

    private native void free(long var1);
}

