/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.Aint;
import mpi.Allocable;
import mpi.AllocablePool;
import mpi.MPIJHelper;

public class Datatype
implements Allocable {
    private long handle;
    private int id;
    private boolean isCustom;
    public static final Datatype NULL = new Datatype(0);
    public static final Datatype BYTE = new Datatype(1);
    public static final Datatype CHAR = new Datatype(2);
    public static final Datatype SHORT = new Datatype(3);
    public static final Datatype BOOLEAN = new Datatype(4);
    public static final Datatype INT = new Datatype(5);
    public static final Datatype LONG = new Datatype(6);
    public static final Datatype FLOAT = new Datatype(7);
    public static final Datatype DOUBLE = new Datatype(8);
    public static final Datatype PACKED = new Datatype(9);
    public static final Datatype INT2 = new Datatype(10);
    public static final Datatype SHORT_INT = new Datatype(11);
    public static final Datatype LONG_INT = new Datatype(12);
    public static final Datatype FLOAT_INT = new Datatype(13);
    public static final Datatype DOUBLE_INT = new Datatype(14);
    public static final Datatype FLOAT_COMPLEX = new Datatype(15);
    public static final Datatype DOUBLE_COMPLEX = new Datatype(16);

    private Datatype(int n) {
        this.id = n;
        this.isCustom = false;
    }

    public Datatype() {
        this.init();
        this.isCustom = true;
    }

    public int getId() {
        return this.id;
    }

    public long getHandle() {
        return this.handle;
    }

    void setHandle(long l) {
        this.handle = l;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public void contiguous(int n, Datatype datatype) {
        long l = MPIJHelper.getDatatypeId(datatype);
        this.MPI_Type_contiguous(n, l, datatype.isCustom(), this.getHandle());
    }

    private native void MPI_Type_contiguous(int var1, long var2, boolean var4, long var5);

    public void commit() {
        this.MPI_Type_commit();
    }

    private native void MPI_Type_commit();

    private void init() {
        this.jni_init();
        AllocablePool.add(this);
    }

    private native void jni_init();

    public int getTypeSize() {
        long l = MPIJHelper.getDatatypeId(this);
        return this.MPI_Type_size(l, this.isCustom());
    }

    private native int MPI_Type_size(long var1, boolean var3);

    @Override
    public void free() {
        AllocablePool.remove(this);
        if (this.isCustom) {
            this.MPI_Type_free();
        }
    }

    private native void MPI_Type_free();

    public void vector(int n, int n2, int n3, Datatype datatype) {
        long l = MPIJHelper.getDatatypeId(datatype);
        this.MPI_Type_vector(n, n2, n3, l, datatype.isCustom(), this.getHandle());
    }

    private native void MPI_Type_vector(int var1, int var2, int var3, long var4, boolean var6, long var7);

    public void hvector(int n, int n2, int n3, Datatype datatype) {
        long l = MPIJHelper.getDatatypeId(datatype);
        this.MPI_Type_create_hvector(n, n2, n3, l, datatype.isCustom(), this.getHandle());
    }

    private native void MPI_Type_create_hvector(int var1, int var2, int var3, long var4, boolean var6, long var7);

    public void indexed(int n, int[] nArray, int[] nArray2, Datatype datatype) {
        long l = MPIJHelper.getDatatypeId(datatype);
        this.MPI_Type_indexed(n, nArray, nArray2, l, datatype.isCustom(), this.getHandle());
    }

    private native void MPI_Type_indexed(int var1, int[] var2, int[] var3, long var4, boolean var6, long var7);

    public void hindexed(int n, int[] nArray, Aint[] aintArray, Datatype datatype) {
        long l = MPIJHelper.getDatatypeId(datatype);
        long[] lArray = new long[aintArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = aintArray[i].getLongValue();
        }
        this.MPI_Type_create_hindexed(n, nArray, lArray, l, datatype.isCustom(), this.getHandle());
    }

    private native void MPI_Type_create_hindexed(int var1, int[] var2, long[] var3, long var4, boolean var6, long var7);

    public void struct(int n, int[] nArray, Aint[] aintArray, Datatype[] datatypeArray) {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = MPIJHelper.getDatatypeId(datatypeArray[i]);
        }
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = datatypeArray[i].isCustom();
        }
        long[] lArray2 = new long[aintArray.length];
        for (int i = 0; i < lArray2.length; ++i) {
            lArray2[i] = aintArray[i].getLongValue();
        }
        this.MPI_Type_struct(n, nArray, lArray2, lArray, blArray, this.getHandle());
    }

    private native void MPI_Type_struct(int var1, int[] var2, long[] var3, long[] var4, boolean[] var5, long var6);
}

